/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.console.strategy;

import com.kms.katalon.console.entity.ConsoleLauncherEntity;
import com.kms.katalon.console.handlers.ArgumentOptionsHandler;
import com.kms.katalon.console.handlers.PluginHandler;
import com.kms.katalon.console.strategy.AbstractConsoleModeStrategy;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.console.entity.OverridingParametersConsoleOptionContributor;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.constants.StringConstants;
import com.kms.katalon.execution.exception.InvalidConsoleArgumentException;
import com.kms.katalon.execution.launcher.ILauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.util.ApiKey;
import com.kms.katalon.license.ConsoleLicenseService;
import com.kms.katalon.logging.LogUtil;
import jakarta.inject.Singleton;
import java.text.MessageFormat;
import java.util.List;
import joptsimple.OptionSet;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class ExecutionModeStrategy
extends AbstractConsoleModeStrategy {
    private int performPreExecutionTasks(ConsoleLauncherEntity consoleLauncherEntity) throws Throwable {
        this.prepareApplicationConfiguration(consoleLauncherEntity);
        int proxyCode = this.checkAndConfigureProxy(consoleLauncherEntity);
        if (proxyCode != 200) {
            return proxyCode;
        }
        return super.performInitializationTasks(consoleLauncherEntity);
    }

    @Override
    protected void prepareApplicationConfiguration(ConsoleLauncherEntity consoleLauncherEntity) throws Exception {
        ArgumentOptionsHandler.getInstance().prepareApplicationConfiguration(consoleLauncherEntity.getApplicationConfigOptions());
    }

    private Long parseOrganizationId(String organizationId) throws InvalidConsoleArgumentException {
        Long orgIdValue = null;
        try {
            if (organizationId != null) {
                orgIdValue = Long.valueOf(organizationId);
            }
            return orgIdValue;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidConsoleArgumentException(String.format(StringConstants.MNG_PRT_ORGANIZATION_ID_IS_INVALID, new Object[0]));
        }
    }

    private void printStatus() {
        int consoleWidth = 80;
        LogUtil.printOutputLine((String)LauncherManager.getInstance().getStatus(consoleWidth));
    }

    @Override
    public int execute(ConsoleLauncherEntity consoleLauncherEntity) throws Throwable {
        int preTaskResult = this.performPreExecutionTasks(consoleLauncherEntity);
        if (preTaskResult != 200) {
            return preTaskResult;
        }
        ProjectEntity project = this.performProjectInitialization(consoleLauncherEntity);
        consoleLauncherEntity.acceptConsoleOptionList(new OverridingParametersConsoleOptionContributor(project).getConsoleOptionList());
        if (ConsoleLicenseService.getInstance().getLicenseType() != null) {
            PluginHandler.loadPluginsToConsole(consoleLauncherEntity, this.context);
        }
        PluginHandler.checkPluginLicense(ApiKey.get(), this.parseOrganizationId(ArgumentOptionsHandler.getInstance().getOrganizationId()));
        KeywordController.getInstance().parseAllCustomKeywordsWithoutRefreshing(project);
        if (consoleLauncherEntity.getOptions().has("appiumDirectory")) {
            RunConfiguration.getInstance().setAppiumDirectoryDefinedWithArgument(String.valueOf(consoleLauncherEntity.getOptions().valueOf("appiumDirectory")));
        }
        consoleLauncherEntity.getConsoleExecutor().execute(project, consoleLauncherEntity.getOptions());
        this.waitForExecutionToFinish(consoleLauncherEntity.getOptions());
        List consoleLaunchers = LauncherManager.getInstance().getSortedLaunchers();
        int exitCode = ((ILauncher)consoleLaunchers.get(consoleLaunchers.size() - 1)).getResult().getReturnCode();
        LogUtil.logInfo((String)MessageFormat.format(ExecutionMessageConstants.RE_EXECUTE_COMPLETED, exitCode));
        return exitCode;
    }

    private void waitForExecutionToFinish(OptionSet options) {
        int progressDelay = 15;
        if (options.has("statusDelay")) {
            String progressDelayString = String.valueOf(options.valueOf("statusDelay"));
            try {
                progressDelay = Integer.valueOf(progressDelayString);
            }
            catch (NumberFormatException numberFormatException) {
                LogUtil.printErrorLine((String)MessageFormat.format(StringConstants.MNG_PRT_INVALID_ARG_CANNOT_PARSE_X_FOR_Y_TO_INTEGER, progressDelayString, "statusDelay"));
            }
        }
        this.waitForExecutionToFinish(progressDelay);
    }

    private void waitForExecutionToFinish(int showProgressDelay) {
        int progressDelayTimeInMiliseconds = (showProgressDelay < 0 ? 15 : showProgressDelay) * 1000;
        do {
            this.printStatus();
            try {
                Thread.sleep(progressDelayTimeInMiliseconds);
            }
            catch (InterruptedException interruptedException) {}
        } while (LauncherManager.getInstance().isAnyLauncherRunning());
        this.printStatus();
    }
}

