/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.components;

import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.execution.components.DriverPropertyNameEditingSupport;
import com.kms.katalon.composer.execution.components.DriverPropertyTypeEditingSupport;
import com.kms.katalon.composer.execution.components.DriverPropertyValueEditingSupport;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.composer.execution.provider.MapPropertyLabelProvider;
import com.kms.katalon.composer.execution.provider.MapPropertyTableViewerContentProvider;
import com.kms.katalon.core.webui.util.OSUtil;
import java.util.Map;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class DriverPropertyMapComposite
extends Composite {
    private static final String DEFAULT_DRIVER_PROPERTY_NAME = "property";
    private Table table;
    private TableViewer tableViewer;
    private ToolItem tltmAddProperty;
    private ToolItem tltmRemoveProperty;
    private ToolItem tltmClearProperty;
    private Map<String, Object> driverPropertyList;

    public DriverPropertyMapComposite(Composite parent) {
        super(parent, 0);
        this.setBackground(ColorUtil.getCompositeBackgroundColorForDialog());
        this.setBackgroundMode(2);
        this.setLayout((Layout)new GridLayout(1, false));
        this.setLayoutData(new GridData(1808));
        Composite composite = new Composite((Composite)this, 0);
        GridLayout gl_composite = new GridLayout(1, false);
        gl_composite.marginWidth = 0;
        gl_composite.marginHeight = 0;
        composite.setLayout((Layout)gl_composite);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite toolbarComposite = new Composite(composite, 0);
        toolbarComposite.setLayout((Layout)new FillLayout(256));
        toolbarComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        ToolBar toolBar = new ToolBar(toolbarComposite, 0x820000);
        toolBar.setForeground(ColorUtil.getToolBarForegroundColor());
        this.tltmAddProperty = new ToolItem(toolBar, 0);
        this.tltmAddProperty.setText(StringConstants.SETT_TOOLITEM_ADD);
        this.tltmAddProperty.setImage(ImageConstants.IMG_16_ADD);
        this.tltmRemoveProperty = new ToolItem(toolBar, 0);
        this.tltmRemoveProperty.setText(StringConstants.SETT_TOOLITEM_REMOVE);
        this.tltmRemoveProperty.setImage(ImageConstants.IMG_16_REMOVE);
        this.tltmClearProperty = new ToolItem(toolBar, 0);
        this.tltmClearProperty.setText(StringConstants.SETT_TOOLITEM_CLEAR);
        this.tltmClearProperty.setImage(ImageConstants.IMG_16_CLEAR);
        this.addToolItemListeners();
        Composite tableComposite = new Composite(composite, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableViewer = new TableViewer(tableComposite, 67586);
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(ControlUtils.shouldLineVisble((Display)this.table.getDisplay()));
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.addTableColumn(this.tableViewer, tableColumnLayout, StringConstants.SETT_COL_PREFERENCE_NAME, 100, 30, new DriverPropertyNameEditingSupport(this.tableViewer));
        this.addTableColumn(this.tableViewer, tableColumnLayout, StringConstants.SETT_COL_PREFERENCE_TYPE, 100, 30, new DriverPropertyTypeEditingSupport(this.tableViewer));
        this.addTableColumn(this.tableViewer, tableColumnLayout, StringConstants.SETT_COL_PREFERENCE_VALUE, 100, 30, new DriverPropertyValueEditingSupport(this.tableViewer));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new MapPropertyLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new MapPropertyTableViewerContentProvider());
    }

    private void addTableColumn(TableViewer parent, TableColumnLayout tableColumnLayout, String headerText, int width, int weight, EditingSupport editingSupport) {
        TableViewerColumn tableColumn = new TableViewerColumn(parent, 0);
        tableColumn.getColumn().setWidth(width);
        tableColumn.getColumn().setMoveable(true);
        tableColumn.getColumn().setText(headerText);
        tableColumn.setEditingSupport(editingSupport);
        tableColumnLayout.setColumnData((Widget)tableColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(weight, tableColumn.getColumn().getWidth()));
    }

    public void setDriverProperties(Map<String, Object> driverPropertyList) {
        this.driverPropertyList = driverPropertyList;
        this.tableViewer.setInput(driverPropertyList);
        if (OSUtil.isMacBigSurOrLater()) {
            this.tableViewer.getTable().redraw();
        }
    }

    private void addToolItemListeners() {
        this.tltmAddProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DriverPropertyMapComposite.this.driverPropertyList.put(DriverPropertyMapComposite.generateNewPropertyName(DriverPropertyMapComposite.this.driverPropertyList), "");
                DriverPropertyMapComposite.this.tableViewer.refresh();
            }
        });
        this.tltmRemoveProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)DriverPropertyMapComposite.this.tableViewer.getSelection();
                if (!selection.isEmpty()) {
                    for (Object selectedObject : selection.toList()) {
                        if (!(selectedObject instanceof Map.Entry)) continue;
                        DriverPropertyMapComposite.this.driverPropertyList.remove(((Map.Entry)selectedObject).getKey());
                    }
                    DriverPropertyMapComposite.this.tableViewer.refresh();
                    if (OSUtil.isMacBigSurOrLater()) {
                        DriverPropertyMapComposite.this.table.redraw();
                    }
                }
            }
        });
        this.tltmClearProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DriverPropertyMapComposite.this.driverPropertyList.clear();
                DriverPropertyMapComposite.this.tableViewer.refresh();
                if (OSUtil.isMacBigSurOrLater()) {
                    DriverPropertyMapComposite.this.table.redraw();
                }
            }
        });
    }

    public static String generateNewPropertyName(Map<String, Object> driverPropertyDictionary) {
        String name = DEFAULT_DRIVER_PROPERTY_NAME;
        if (driverPropertyDictionary.get(name) == null) {
            return name;
        }
        int index = 0;
        boolean isUnique = false;
        while (!isUnique) {
            String newName;
            boolean bl = isUnique = driverPropertyDictionary.get(newName = name + "_" + ++index) == null;
        }
        return name + "_" + index;
    }

    public Map<String, Object> getDriverProperties() {
        return this.driverPropertyList;
    }
}

