/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.debug.handler;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.controller.ProjectController;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class RemoveAllBreakpointHandler {
    @CanExecute
    public boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null && DebugPlugin.getDefault().getBreakpointManager().hasBreakpoints();
    }

    @Execute
    public void execute() {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = breakpointManager.getBreakpoints();
        if (breakpoints.length < 1) {
            return;
        }
        IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        boolean prompt = store.getBoolean("org.eclipse.debug.ui.remove_all_breakpoints_prompt");
        if (prompt) {
            MessageDialogWithToggle mdwt = MessageDialogWithToggle.openYesNoQuestion((Shell)window.getShell(), (String)ActionMessages.RemoveAllBreakpointsAction_0, (String)ActionMessages.RemoveAllBreakpointsAction_1, (String)ActionMessages.RemoveAllBreakpointsAction_3, (boolean)false, null, null);
            if (mdwt.getReturnCode() != 2) {
                return;
            }
            store.setValue("org.eclipse.debug.ui.remove_all_breakpoints_prompt", !mdwt.getToggleState());
        }
        this.startRemoveAllBreakpointJob(breakpoints);
    }

    private void startRemoveAllBreakpointJob(final IBreakpoint[] breakpoints) {
        new Job(ActionMessages.RemoveAllBreakpointsAction_2){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    DebugUITools.deleteBreakpoints((IBreakpoint[])breakpoints, null, (IProgressMonitor)monitor);
                }
                catch (CoreException e) {
                    LoggerSingleton.logError((Throwable)e);
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }
}

