/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.debug.handler;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.handler.AbstractHandler;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.execution.constants.StringConstants;
import org.codehaus.groovy.eclipse.editor.GroovyEditor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ToggleBreakpointHandler
extends AbstractHandler {
    public boolean canExecute() {
        GroovyEditor activeEditor = this.getActiveGroovyEditor();
        return activeEditor != null && this.getSelection(activeEditor) != null;
    }

    public void execute() {
        GroovyEditor editor = this.getActiveGroovyEditor();
        ISelection selection = this.getSelection(editor);
        try {
            DebugUITools.getToggleBreakpointsTargetManager().getToggleBreakpointsTarget((IWorkbenchPart)editor, selection).toggleLineBreakpoints((IWorkbenchPart)editor, selection);
        }
        catch (CoreException e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.HAND_ERROR_MSG_CANNOT_TOGGLE_LINE_BREAKPOINT, (String)e.getMessage());
        }
    }

    private ISelection getSelection(GroovyEditor editor) {
        ISelectionProvider selectionProvider = editor.getSelectionProvider();
        return selectionProvider != null ? selectionProvider.getSelection() : null;
    }

    private GroovyEditor getActiveGroovyEditor() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return null;
        }
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow == null) {
            return null;
        }
        IWorkbenchPart activePart = activeWindow.getPartService().getActivePart();
        return activePart instanceof GroovyEditor ? (GroovyEditor)activePart : null;
    }
}

