/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.handlers;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.execution.collector.DriverConnectorEditorCollector;
import com.kms.katalon.composer.execution.components.contributor.IDriverConnectorEditorContributor;
import jakarta.inject.Inject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class EvaluateDriverConnectorEditorContributionsHandler {
    private static final String IDRIVERCONNECTOR_EDITOR_ATTRIBUTE_NAME = "driver.connector.editor";
    private static final String IDRIVERCONNECTOR_EDITOR_CONTRIBUTOR_ID = "com.kms.katalon.composer.execution.driverConnectorEditor";
    @Inject
    private IEclipseContext context;

    @Inject
    public void execute(IExtensionRegistry registry) {
        this.evaluate(registry);
    }

    private void evaluate(IExtensionRegistry registry) {
        IConfigurationElement[] config = registry.getConfigurationElementsFor(IDRIVERCONNECTOR_EDITOR_CONTRIBUTOR_ID);
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                Object o = e.createExecutableExtension(IDRIVERCONNECTOR_EDITOR_ATTRIBUTE_NAME);
                this.executeExtension(o);
                ++n2;
            }
        }
        catch (CoreException ex) {
            LoggerSingleton.logError((Throwable)ex);
        }
    }

    private void executeExtension(final Object o) {
        ISafeRunnable runnable = new ISafeRunnable(){

            public void handleException(Throwable e) {
            }

            public void run() throws Exception {
                if (o instanceof IDriverConnectorEditorContributor) {
                    DriverConnectorEditorCollector driverConnectorEditorCollector = DriverConnectorEditorCollector.getInstance();
                    ContextInjectionFactory.inject((Object)driverConnectorEditorCollector, (IEclipseContext)EvaluateDriverConnectorEditorContributionsHandler.this.context);
                    driverConnectorEditorCollector.addDriverConnectorEditorContributor((IDriverConnectorEditorContributor)o);
                }
            }
        };
        SafeRunner.run((ISafeRunnable)runnable);
    }
}

