/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.launcher;

import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.execution.launcher.model.LaunchMode;
import com.kms.katalon.groovy.helper.ClasspathHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.codehaus.groovy.eclipse.launchers.GroovyScriptLaunchShortcut;
import org.codehaus.groovy.eclipse.launchers.LaunchShortcutHelper;
import org.codehaus.jdt.groovy.model.GroovyProjectFacade;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.viewers.ILabelProvider;

public class IDELaunchShorcut
extends GroovyScriptLaunchShortcut {
    private static final String JVM_ARGUMENT_MAX_MEMORY_KEY = "-Xmx";

    public ILaunchConfigurationType getGroovyLaunchConfigType() {
        return IDELaunchShorcut.getLaunchManager().getLaunchConfigurationType("com.kms.katalon.composer.execution.scriptLaunchConfiguration");
    }

    protected String classToRun() {
        return "groovy.ui.GroovyMain";
    }

    public static void cleanConfiguration(ILaunch launch) {
        IDELaunchShorcut.getLaunchManager().removeLaunch(launch);
    }

    public static void cleanAllConfigurations() throws CoreException {
        while (IDELaunchShorcut.getLaunchManager().getLaunchConfigurations().length > 0) {
            IDELaunchShorcut.getLaunchManager().getLaunchConfigurations()[0].delete();
        }
    }

    private ILaunch internallyLaunchGroovy(ICompilationUnit unit, String mode, IRunConfiguration runConfiguration, Map<String, String> environmentVariables) throws CoreException, ExecutionException {
        Object vmArguments;
        IType[] types = unit.getAllTypes();
        IType runType = this.findClassToRun(types);
        if (runType == null) {
            return null;
        }
        IJavaProject javaProject = unit.getJavaProject();
        Map launchConfigProperties = this.createLaunchProperties(runType, javaProject);
        ILaunchConfigurationWorkingCopy workingConfig = this.findOrCreateLaunchConfig(launchConfigProperties, runType.getElementName());
        try {
            environmentVariables.putAll(runConfiguration.getAdditionalEnvironmentVariables());
        }
        catch (ExecutionException | IOException e) {
            throw new ExecutionException(e);
        }
        if (environmentVariables != null && !environmentVariables.isEmpty()) {
            workingConfig.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, environmentVariables);
        }
        if (!((String)(vmArguments = workingConfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, ""))).contains(JVM_ARGUMENT_MAX_MEMORY_KEY)) {
            vmArguments = (String)vmArguments + " -Xmx" + IDELaunchShorcut.byteToMegabytes(Runtime.getRuntime().maxMemory()) + "m";
        }
        List<String> vmArgs = Arrays.asList(runConfiguration.getVmArgs());
        for (String eachArg : vmArgs) {
            vmArguments = (String)vmArguments + " " + eachArg;
        }
        workingConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, (String)vmArguments);
        Object[] classPath = ClasspathHelper.getDefaultRuntimeClasspath();
        if (classPath == null || ArrayUtils.isEmpty((Object[])classPath)) {
            classPath = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject);
        }
        List<Object> classpath = Arrays.asList(classPath);
        workingConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, classpath);
        workingConfig.setAttribute("org.eclipse.debug.core.TERMINATE_DESCENDANTS", false);
        ILaunchConfiguration config = workingConfig.doSave();
        config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
        return config.launch(mode, (IProgressMonitor)new NullProgressMonitor());
    }

    private IType findClassToRun(IType[] types) {
        IType returnValue = null;
        ArrayList<IType> candidates = new ArrayList<IType>();
        int i = 0;
        while (i < types.length) {
            if (GroovyProjectFacade.hasGroovyMainMethod((IType)types[i])) {
                candidates.add(types[i]);
            }
            ++i;
        }
        returnValue = candidates.size() == 1 ? (IType)candidates.get(0) : (IType)LaunchShortcutHelper.chooseFromList(Arrays.asList(types), (ILabelProvider)new JavaUILabelProvider(), (String)LaunchShortcutHelper.SelectMainTypeDialog_title, (String)LaunchShortcutHelper.SelectMainTypeDialog_message);
        return returnValue;
    }

    private static long byteToMegabytes(long maxMemory) {
        return maxMemory / 0x100000L;
    }

    public ILaunch launch(IFile scriptFile, LaunchMode launchMode, IRunConfiguration runConfiguration, Map<String, String> environmentVariables) throws CoreException, ExecutionException {
        if (scriptFile == null) {
            return null;
        }
        ICompilationUnit compilationUnit = JavaCore.createCompilationUnitFrom((IFile)scriptFile);
        return compilationUnit != null ? this.internallyLaunchGroovy(compilationUnit, launchMode.toString(), runConfiguration, environmentVariables) : null;
    }
}

