/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.launcher;

import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.execution.launcher.IDEObservableLauncher;
import com.kms.katalon.composer.execution.launcher.IDEObservableParentLauncher;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.core.appium.util.AppiumVersionUtil;
import com.kms.katalon.core.logging.XmlLogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.mobile.util.MobileRunConfigurationUtil;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.report.ReportCollectionEntity;
import com.kms.katalon.entity.testcase.RecordOption;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.entity.testsuite.TestSuiteRunConfiguration;
import com.kms.katalon.execution.collector.ExecutionInfo;
import com.kms.katalon.execution.collector.ExecutionInfoCollector;
import com.kms.katalon.execution.collector.SelfHealingExecutionReport;
import com.kms.katalon.execution.collector.SelfHealingExecutionReportCollector;
import com.kms.katalon.execution.entity.EmailConfig;
import com.kms.katalon.execution.entity.TestSuiteCollectionExecutedEntity;
import com.kms.katalon.execution.launcher.ReportableLauncher;
import com.kms.katalon.execution.launcher.TestSuiteCollectionLauncher;
import com.kms.katalon.execution.launcher.listener.LauncherEvent;
import com.kms.katalon.execution.launcher.listener.LauncherListener;
import com.kms.katalon.execution.launcher.listener.LauncherNotifiedObject;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.launcher.model.LaunchMode;
import com.kms.katalon.execution.launcher.result.LauncherStatus;
import com.kms.katalon.execution.mobile.util.MobileExecutionUtil;
import com.kms.katalon.execution.setting.WebUiExecutionSettingStore;
import com.kms.katalon.execution.util.ExecutionUtil;
import com.kms.katalon.execution.util.MailUtil;
import com.kms.katalon.session.core.model.Organization;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.model.Project;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.testops.core.model.AnalyticsIntegrationSetting;
import com.kms.katalon.testops.core.services.ITestOpsController;
import com.kms.katalon.tracking.model.TestEntityTrackingInfo;
import com.kms.katalon.tracking.model.TestSuiteCollectionTrackingInfo;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.e4.core.services.events.IEventBroker;

public class IDETestSuiteCollectionLauncher
extends TestSuiteCollectionLauncher
implements IDEObservableLauncher,
IDEObservableParentLauncher,
LauncherListener {
    @Inject
    private IFeatureController featureController;
    @Inject
    private ITestOpsController testOpsController;
    private boolean observed = false;
    private List<XmlLogRecord> syncRequiredlogRecords = Collections.synchronizedList(new ArrayList());

    public IDETestSuiteCollectionLauncher(TestSuiteCollectionExecutedEntity executedEntity, LauncherManager parentManager, List<ReportableLauncher> subLaunchers, TestSuiteCollectionEntity.ExecutionMode executionMode, ReportCollectionEntity reportCollection) {
        super(executedEntity, parentManager, subLaunchers, executionMode, reportCollection, null);
    }

    private IEventBroker getEventBroker() {
        return EventBrokerSingleton.getInstance().getEventBroker();
    }

    public void start() throws IOException {
        this.getEventBroker().post("JOB/REFRESH", (Object)this.getId());
        this.getEventBroker().send("CONSOLE_LOG/RESET", (Object)this.getId());
        super.start();
    }

    protected void postExecution() {
        super.postExecution();
        this.getEventBroker().post("org/eclipse/e4/ui/renderer/requestEnablementUpdate", (Object)"ALL");
        TestSuiteCollectionEntity testSuiteCollectionEntity = this.getExecutedEntity().getEntity();
        this.getEventBroker().post("TEST_SUITE_COLLECTION/FINISHED", (Object)testSuiteCollectionEntity);
        File reportFolder = this.getReportFolder().getParentFile().getParentFile();
        boolean canUseSelfHealing = this.featureController.canUse(ProductFeature.SELF_HEALING);
        boolean isSelfHealingEnabled = canUseSelfHealing && WebUiExecutionSettingStore.getStore().getSelfHealingEnabled(canUseSelfHealing);
        SelfHealingExecutionReport selfHealingReport = SelfHealingExecutionReportCollector.getInstance().collect(isSelfHealingEnabled, reportFolder);
        ExecutionInfo executionInfo = ExecutionInfoCollector.getInstance().collect();
        TestSuiteCollectionEntity tscEntity = this.getExecutedEntity().getEntity();
        TestSuiteCollectionEntity.ExecutionMode executionMode = tscEntity.getExecutionMode();
        String tscId = ExecutionUtil.getTestSuiteCollectionId((String)tscEntity.getId());
        if (executionMode == TestSuiteCollectionEntity.ExecutionMode.PARALLEL) {
            int maxConcurrentInstances = this.getExecutedEntity().getEntity().getMaxConcurrentInstances();
            Trackings.trackExecuteParallelTestSuiteCollectionInGuiMode((TestSuiteCollectionTrackingInfo)this.buildTSCTrackingInfo(selfHealingReport, executionInfo, maxConcurrentInstances, tscId, this.countNumTestCaseRecordedByTestCloud(tscEntity), this.countNumAIAPITestCase(tscEntity)));
        } else {
            Trackings.trackExecuteSequentialTestSuiteCollectionInGuiMode((TestSuiteCollectionTrackingInfo)this.buildTSCTrackingInfo(selfHealingReport, executionInfo, 0, tscId, this.countNumTestCaseRecordedByTestCloud(tscEntity), this.countNumAIAPITestCase(tscEntity)));
        }
    }

    private int countNumTestCaseRecordedByTestCloud(TestSuiteCollectionEntity tscEntity) {
        int result = 0;
        for (TestSuiteRunConfiguration tsRunConfig : tscEntity.getTestSuiteRunConfigurations()) {
            if (!tsRunConfig.isRunEnabled()) continue;
            TestSuiteEntity tsEntity = tsRunConfig.getTestSuiteEntity();
            for (TestSuiteTestCaseLink link : tsEntity.getTestSuiteTestCaseLinks()) {
                try {
                    TestCaseEntity testCase = TestCaseController.getInstance().getTestCaseByDisplayId(link.getTestCaseId());
                    if (!RecordOption.TESTCLOUD_NATIVE_MOBILE.equals((Object)testCase.getRecordOption())) continue;
                    ++result;
                }
                catch (ControllerException e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }
        }
        return result;
    }

    private int countNumAIAPITestCase(TestSuiteCollectionEntity tscEntity) {
        int result = 0;
        for (TestSuiteRunConfiguration tsRunConfig : tscEntity.getTestSuiteRunConfigurations()) {
            if (!tsRunConfig.isRunEnabled()) continue;
            TestSuiteEntity tsEntity = tsRunConfig.getTestSuiteEntity();
            for (TestSuiteTestCaseLink link : tsEntity.getTestSuiteTestCaseLinks()) {
                try {
                    TestCaseEntity testCase = TestCaseController.getInstance().getTestCaseByDisplayId(link.getTestCaseId());
                    if (!testCase.isAPITestGenerationTestCase()) continue;
                    ++result;
                }
                catch (ControllerException e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }
        }
        return result;
    }

    protected String getExecutionResult() {
        String resultExcution = null;
        resultExcution = this.getResult().getNumFailures() > 0 ? TestStatus.TestStatusValue.FAILED.toString() : (this.getResult().getNumErrors() > 0 ? TestStatus.TestStatusValue.ERROR.toString() : TestStatus.TestStatusValue.PASSED.toString());
        return resultExcution;
    }

    private TestSuiteCollectionTrackingInfo buildTSCTrackingInfo(SelfHealingExecutionReport selfHealingReport, ExecutionInfo executionInfo, int maxConcurrentInstances, String tscId, int testCloudRecorderTestCaseCount, int numberOfAIAPITestCase) {
        String executionResult = this.getExecutionResult();
        TestSuiteCollectionExecutedEntity tscExecutedEntity = this.getExecutedEntity();
        int numberOfEmailsSent = MailUtil.getNumberOfEmailsSentForTestSuiteCollection((boolean)this.getAreEmailsSent(), (EmailConfig)tscExecutedEntity.getEmailConfig(tscExecutedEntity.getEntity().getProject()));
        TestSuiteCollectionTrackingInfo trackingInfo = new TestSuiteCollectionTrackingInfo();
        trackingInfo.setResult(executionResult);
        trackingInfo.setDuration(this.getEndTime().getTime() - this.getStartTime().getTime());
        trackingInfo.setEnableSelfHealing(selfHealingReport.isEnabled());
        trackingInfo.setTriggerSelfHealing(selfHealingReport.isTriggered());
        trackingInfo.setHealingInfo(selfHealingReport.getHealingInfo());
        trackingInfo.setTotalTestCases(this.getResult().getTotalTestCases());
        trackingInfo.setTotalRunTestSuite(tscExecutedEntity.getExecutedItems().size());
        trackingInfo.setPassedTestCases(this.getResult().getNumPasses());
        trackingInfo.setFailedTestCases(this.getResult().getNumFailures());
        trackingInfo.setErrorTestCases(this.getResult().getNumErrors());
        trackingInfo.setSkippedTestCases(this.getResult().getNumSkips());
        trackingInfo.setIncompleteTestCases(this.getResult().getNumIncomplete());
        ApplicationContext context = ApplicationContext.getInstance();
        Organization organization = context.getOrganization();
        if (Objects.nonNull(organization)) {
            trackingInfo.setOrgId(organization.getId());
        }
        trackingInfo.setEnableScreenshot(executionInfo.isEnableScreenshot());
        trackingInfo.setEnableVideo(executionInfo.isEnableVideoRecording());
        trackingInfo.setEnableHideHostname(ExecutionUtil.isEnabledHideHostname().booleanValue());
        trackingInfo.setVideoRecordingLevel(executionInfo.getVideoRecordingLevel());
        trackingInfo.setNumberOfEmailsSent(numberOfEmailsSent);
        trackingInfo.setMaxConcurrentInstances(maxConcurrentInstances);
        trackingInfo.setAdditionalProps(this.getIntegratedContributionsTrackingData());
        trackingInfo.setTestSuiteCollectionId(tscId);
        trackingInfo.setTestcloudRecorderTestCaseCount(testCloudRecorderTestCaseCount);
        trackingInfo.setNumberOfAIAPITestCase(numberOfAIAPITestCase);
        trackingInfo.setReportGenerationTypes(this.getReportGenerationTypes());
        this.addAppiumInfoForTracking((TestEntityTrackingInfo)trackingInfo);
        this.addIntegrationSettingInfoForTracking((TestEntityTrackingInfo)trackingInfo);
        return trackingInfo;
    }

    private void addAppiumInfoForTracking(TestEntityTrackingInfo trackInfo) {
        Predicate<TestSuiteRunConfiguration> containMobileOrCustomMobileRunConfig = testSuiteRunConfig -> {
            String groupName = testSuiteRunConfig.getConfiguration().getGroupName();
            if (groupName.equals("Mobile") || groupName.equals("Custom")) {
                String runConfigId = testSuiteRunConfig.getConfiguration().getRunConfigurationId();
                boolean isMobileRunConfigId = MobileRunConfigurationUtil.isAndroidPlatform((String)runConfigId) || MobileRunConfigurationUtil.isiOSPlatform((String)runConfigId);
                boolean isCustomMobileRunConfigId = MobileRunConfigurationUtil.usingCustomRunConfigurationId((String)runConfigId, (String)ProjectController.getInstance().getCurrentProject().getFolderLocation());
                return (isCustomMobileRunConfigId || isMobileRunConfigId) && testSuiteRunConfig.isRunEnabled();
            }
            return false;
        };
        boolean isContainMobileRunConfig = this.getExecutedEntity().getEntity().getTestSuiteRunConfigurations().stream().anyMatch(containMobileOrCustomMobileRunConfig);
        if (isContainMobileRunConfig) {
            String appiumVersion = AppiumVersionUtil.readVersionFromFile((String)MobileExecutionUtil.findAppiumDir());
            trackInfo.setAppiumVersion(appiumVersion);
        }
    }

    private void addIntegrationSettingInfoForTracking(TestEntityTrackingInfo trackInfo) {
        String analyticsProjectId = "";
        String analyticsAccountId = "";
        AnalyticsIntegrationSetting integratedSetting = this.testOpsController.getRequestOptions().getIntegratedSetting();
        if (integratedSetting != null) {
            Project project = integratedSetting.getProject();
            analyticsProjectId = project != null ? project.getId().toString() : "";
            analyticsAccountId = project != null ? project.getAccountId().toString() : "";
        }
        trackInfo.setTestOpsProjectId(analyticsProjectId);
        trackInfo.setTestOpsAccountId(analyticsAccountId);
        trackInfo.setTestCloudProjectId(analyticsProjectId);
        trackInfo.setTestCloudAccountId(analyticsAccountId);
    }

    public void setStatus(LauncherStatus status, String message) {
        super.setStatus(status, message);
        this.getEventBroker().post("JOB/REFRESH", null);
    }

    @Override
    public void setObserved(boolean observed) {
        this.observed = observed;
    }

    @Override
    public boolean isObserved() {
        return this.observed;
    }

    @Override
    public LaunchMode getMode() {
        return LaunchMode.RUN;
    }

    @Override
    public String getDisplayMessage() {
        return "<" + this.getStatus().toString() + "> - Test Suite Collection";
    }

    @Override
    public void suspend() {
    }

    @Override
    public void resume() {
    }

    @Override
    public List<XmlLogRecord> getLogRecords() {
        return this.syncRequiredlogRecords;
    }

    @Override
    public ILaunch getLaunch() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleLauncherEvent(LauncherEvent event, LauncherNotifiedObject object) {
        switch (event) {
            case UPDATE_RECORD: {
                List<XmlLogRecord> list = this.syncRequiredlogRecords;
                synchronized (list) {
                    this.syncRequiredlogRecords.add((XmlLogRecord)object.getObject());
                }
                this.notifyLauncherChanged(LauncherEvent.UPDATE_RECORD, this.getId());
                break;
            }
            default: {
                super.handleLauncherEvent(event, object);
            }
        }
    }

    @Override
    public List<IDEObservableLauncher> getObservableLaunchers() {
        ArrayList<IDEObservableLauncher> subIDEObservableLaunchers = new ArrayList<IDEObservableLauncher>();
        for (ReportableLauncher subLauncher : this.subLaunchers) {
            if (!(subLauncher instanceof IDEObservableLauncher)) continue;
            subIDEObservableLaunchers.add((IDEObservableLauncher)subLauncher);
        }
        return subIDEObservableLaunchers;
    }
}

