/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.logviewer;

import com.kms.katalon.core.util.internal.DateUtil;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.apache.commons.lang3.StringUtils;

public class LogViewerFormatUtils {
    private static final String LOG_TIME_FORMAT = "MM-dd-yyyy hh:mm:ss a";
    private static final DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("MM-dd-yyyy hh:mm:ss a");

    public static String formatLogTime(String time) {
        try {
            OffsetDateTime dateTime = OffsetDateTime.parse(time);
            return dateTime.format(outputFormatter);
        }
        catch (DateTimeParseException dateTimeParseException) {
            return time;
        }
    }

    public static String formatDuration(String startTime, String endTime) {
        if (StringUtils.isBlank((CharSequence)startTime) || StringUtils.isBlank((CharSequence)endTime)) {
            return "";
        }
        try {
            OffsetDateTime start = OffsetDateTime.parse(startTime);
            OffsetDateTime end = OffsetDateTime.parse(endTime);
            long startMillis = start.toInstant().toEpochMilli();
            long endMillis = end.toInstant().toEpochMilli();
            return DateUtil.getElapsedTime((long)startMillis, (long)endMillis);
        }
        catch (DateTimeParseException dateTimeParseException) {
            return "";
        }
    }
}

