/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.part;

import com.kms.katalon.composer.components.controls.HelpComposite;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.composer.execution.dialog.GenerateCommandDialog;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.session.core.model.Organization;
import com.kms.katalon.testops.core.model.TestOpsRequestOptions;
import com.kms.katalon.testops.core.services.ITestOpsController;
import com.kms.katalon.testops.services.TestOpsController;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;

public class GenerateCommandAuthenticationPart
extends Composite {
    private Text txtAPIKey;
    private static final String KATALON_STUDIO_ONLINE_LICENSE_DOCUMENT = StringConstants.KATALON_STUDIO_ONLINE_LICENSE_DOCUMENT;
    private static final String DEFAULT_ORGANIZATION = StringConstants.DEFAULT_ORGANIZATION;
    private ComboViewer cbOrganizations;
    private Combo ccbOrganizations;
    private static final String ARG_API_KEY = "apiKey";
    private static final String ARG_ORG_ID_KEY = "orgID";
    private Organization selectedOrganization = null;
    private ITestOpsController testOpsController = TestOpsController.getInstance();

    public GenerateCommandAuthenticationPart(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.createAuthenticationPart();
        this.fetchTestOpsData();
    }

    private void createAuthenticationPart() {
        Group grpAuthenContainer = new Group((Composite)this, 0);
        grpAuthenContainer.setLayout((Layout)new GridLayout(3, false));
        grpAuthenContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpAuthenContainer.setText(StringConstants.DIA_GRP_AUTHENTICATION);
        Label lblAPIKey = new Label((Composite)grpAuthenContainer, 0);
        lblAPIKey.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        lblAPIKey.setText(StringConstants.DIA_LBL_APIKEY);
        this.txtAPIKey = new Text((Composite)grpAuthenContainer, 2048);
        GridData gdTxtAPIKey = new GridData(16384, 0x1000000, false, false, 3, 1);
        gdTxtAPIKey.widthHint = 600;
        this.txtAPIKey.setLayoutData((Object)gdTxtAPIKey);
        this.createNoticesComposite((Composite)grpAuthenContainer);
        Label lblOrgs = new Label((Composite)grpAuthenContainer, 0);
        lblOrgs.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        lblOrgs.setText(StringConstants.DIA_LBL_ORGANIZATION);
        this.cbOrganizations = new ComboViewer((Composite)grpAuthenContainer, 8);
        this.ccbOrganizations = this.cbOrganizations.getCombo();
        this.ccbOrganizations.setLayout((Layout)new GridLayout());
        this.ccbOrganizations.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.ccbOrganizations.setEnabled(false);
        this.cbOrganizations.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cbOrganizations.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Organization) {
                    Organization organization = (Organization)element;
                    return organization.getName();
                }
                return super.getText(element);
            }
        });
        this.cbOrganizations.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Organization organization;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                GenerateCommandAuthenticationPart.this.selectedOrganization = organization = (Organization)selection.getFirstElement();
                GenerateCommandAuthenticationPart.this.cbOrganizations.refresh();
            }
        });
        this.createHelpComposite((Composite)grpAuthenContainer);
    }

    private void createHelpComposite(Composite parent) {
        HelpComposite btnHelp = new HelpComposite(parent, KATALON_STUDIO_ONLINE_LICENSE_DOCUMENT);
        btnHelp.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
    }

    public void createNoticesComposite(Composite parent) {
        Composite noticesComposite = new Composite(parent, 0);
        noticesComposite.setLayout((Layout)new GridLayout(1, false));
        noticesComposite.setLayoutData((Object)new GridData(16384, 128, true, false, 3, 1));
        Link lblApiKeyUsage = new Link(noticesComposite, 64);
        lblApiKeyUsage.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        ControlUtils.setFontStyle((Control)lblApiKeyUsage, (int)3, (int)-1);
        lblApiKeyUsage.setText(StringConstants.DIA_LBL_API_KEY_USAGE);
        lblApiKeyUsage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    Program.launch((String)DocumentationMessageConstants.KSTORE_API_KEYS_USAGE);
                }
                catch (Exception ex) {
                    LogUtil.logError((Throwable)ex);
                }
            }
        });
        Link lblConsoleModeRequirement = new Link(noticesComposite, 64);
        lblConsoleModeRequirement.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        ControlUtils.setFontStyle((Control)lblConsoleModeRequirement, (int)3, (int)-1);
        lblConsoleModeRequirement.setText(StringConstants.MSG_CONSOLE_MODE_REQUIREMENT);
        lblConsoleModeRequirement.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    Program.launch((String)DocumentationMessageConstants.RUNTIME_ENGINE_INTRODUCTION);
                }
                catch (Exception ex) {
                    LogUtil.logError((Throwable)ex);
                }
            }
        });
    }

    private void fetchTestOpsData() {
        Thread fetchTestOpsData = new Thread(() -> {
            try {
                String apiKey = this.getApiKey();
                Organization[] organizations = this.getKREOrganizations();
                UISynchronizeService.asyncExec(() -> {
                    if (!this.txtAPIKey.isDisposed() && apiKey != null) {
                        this.txtAPIKey.setText(apiKey);
                    }
                    if (!this.ccbOrganizations.isDisposed() && organizations != null) {
                        this.ccbOrganizations.setEnabled(true);
                        this.cbOrganizations.setInput((Object)organizations);
                        this.ccbOrganizations.select(0);
                    }
                });
            }
            catch (Exception exception) {
                LoggerSingleton.logError((Throwable)exception);
            }
        });
        fetchTestOpsData.start();
    }

    private String getApiKey() {
        try {
            LogUtil.logInfo((String)"Fetching API Key using token...");
            TestOpsRequestOptions requestOptions = this.testOpsController.getRequestOptions(true);
            return this.testOpsController.fetchAPIKey(requestOptions);
        }
        catch (Exception exception) {
            LoggerSingleton.logError((Throwable)exception);
            return null;
        }
    }

    private Organization[] getKREOrganizations() {
        try {
            LogUtil.logInfo((String)"Fetching organizations using token...");
            ArrayList<Organization> fetchedOrganizations = new ArrayList<Organization>();
            fetchedOrganizations.addAll(this.testOpsController.getKreOrganizations());
            LogUtil.logInfo((String)(fetchedOrganizations.size() + " KRE organization(s) fetched"));
            if (!fetchedOrganizations.isEmpty()) {
                Organization defaultOrganization = new Organization();
                defaultOrganization.setName(DEFAULT_ORGANIZATION);
                fetchedOrganizations.add(0, defaultOrganization);
                return fetchedOrganizations.toArray(new Organization[fetchedOrganizations.size()]);
            }
        }
        catch (Exception exception) {
            LoggerSingleton.logError((Throwable)exception);
        }
        return null;
    }

    public Map<String, String> getConsoleArgsMap(GenerateCommandDialog.GenerateCommandMode generateCommandMode) {
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        if (!StringUtils.isEmpty((CharSequence)this.txtAPIKey.getText())) {
            if (generateCommandMode == GenerateCommandDialog.GenerateCommandMode.PROPERTIES_FILE) {
                args.put(ARG_API_KEY, this.txtAPIKey.getText());
            } else {
                args.put(ARG_API_KEY, this.wrapArgumentValue(this.txtAPIKey.getText()));
            }
        }
        if (this.selectedOrganization != null && this.selectedOrganization.getId() != null) {
            args.put(ARG_ORG_ID_KEY, this.selectedOrganization.getId().toString());
        }
        return args;
    }

    private String wrapArgumentValue(String value) {
        return "\"" + value + "\"";
    }
}

