/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.settings;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.execution.constants.ComposerExecutionMessageConstants;
import com.kms.katalon.composer.execution.settings.AbstractExecutionSettingPage;
import com.kms.katalon.execution.webservice.setting.WebServiceExecutionSettingStore;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.IProductFeatureDialog;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.inject.Inject;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class WebServiceExecutionSettingPage
extends AbstractExecutionSettingPage {
    public static final short RESPONSE_SIZE_MIN_VALUE = 0;
    public static final int RESPONSE_SIZE_MAX_VALUE = Integer.MAX_VALUE;
    @Inject
    private IFeatureController featureController;
    @Inject
    private IProductFeatureDialog productFeatureDialog;
    private WebServiceExecutionSettingStore webServiceSettingStore = WebServiceExecutionSettingStore.getStore();
    private Text txtConnectionTimeout;
    private Text txtSocketTimeout;
    private Text txtResponseSizeLimit;
    private Button checkboxFollowRedirects;

    @Override
    protected void createSettingsArea(Composite container) {
        Composite mainContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout(1, false);
        mainContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        layout.verticalSpacing = 10;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainContainer.setLayout((Layout)layout);
        this.createHTTPSettings(mainContainer);
        this.createFollowRedirectsSetting(mainContainer);
    }

    private void createFollowRedirectsSetting(Composite parent) {
        this.checkboxFollowRedirects = new Button(parent, 32);
        this.checkboxFollowRedirects.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.checkboxFollowRedirects.setText(ComposerExecutionMessageConstants.PREF_WEBSERVICE_LBL_FOLLOW_REDIRECTS);
    }

    private void createHTTPSettings(Composite parent) {
        Group grpHTTPSettings = new Group(parent, 0);
        grpHTTPSettings.setText(ComposerExecutionMessageConstants.PREF_WEBSERVICE_GROUP_LBL_HTTP);
        GridLayout glGrpHTTPSettings = new GridLayout();
        grpHTTPSettings.setLayout((Layout)glGrpHTTPSettings);
        grpHTTPSettings.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Composite httpComposite = new Composite((Composite)grpHTTPSettings, 0);
        GridLayout glHTTPComposite = new GridLayout(2, false);
        glHTTPComposite.verticalSpacing = 10;
        glHTTPComposite.marginHeight = 0;
        glHTTPComposite.marginWidth = 0;
        httpComposite.setLayout((Layout)glHTTPComposite);
        Label lblConnectionTimeout = new Label(httpComposite, 0);
        lblConnectionTimeout.setText(ComposerExecutionMessageConstants.PREF_WEBSERVICE_LBL_CONNECTION_TIMEOUT);
        GridData gdLblConnectionTimeout = new GridData(16384, 0x1000000, false, false, 1, 1);
        lblConnectionTimeout.setLayoutData((Object)gdLblConnectionTimeout);
        this.txtConnectionTimeout = new Text(httpComposite, 2048);
        GridData gdTxtConnectionTimeout = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdTxtConnectionTimeout.widthHint = 60;
        this.txtConnectionTimeout.setLayoutData((Object)gdTxtConnectionTimeout);
        this.txtConnectionTimeout.setEnabled(this.canCustomizeRequestTimeout());
        Label lblSocketTimeout = new Label(httpComposite, 0);
        lblSocketTimeout.setText(ComposerExecutionMessageConstants.PREF_WEBSERVICE_LBL_SOCKET_TIMEOUT);
        GridData gdLblSocketTimeout = new GridData(16384, 0x1000000, false, false, 1, 1);
        lblSocketTimeout.setLayoutData((Object)gdLblSocketTimeout);
        this.txtSocketTimeout = new Text(httpComposite, 2048);
        GridData gdTxtSocketTimeout = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdTxtSocketTimeout.widthHint = 60;
        this.txtSocketTimeout.setLayoutData((Object)gdTxtSocketTimeout);
        this.txtSocketTimeout.setEnabled(this.canCustomizeRequestTimeout());
        Label lblResponseSizeLimit = new Label(httpComposite, 0);
        lblResponseSizeLimit.setText(ComposerExecutionMessageConstants.PREF_WEBSERVICE_LBL_MAX_RESPONSE_SIZE);
        GridData gdLblResponseSizeLimit = new GridData(16384, 0x1000000, false, false, 1, 1);
        lblResponseSizeLimit.setLayoutData((Object)gdLblResponseSizeLimit);
        this.txtResponseSizeLimit = new Text(httpComposite, 2048);
        GridData gdTxtResponseSizeLimit = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdTxtResponseSizeLimit.widthHint = 60;
        this.txtResponseSizeLimit.setLayoutData((Object)gdTxtResponseSizeLimit);
        this.txtResponseSizeLimit.setEnabled(this.canCustomizeResponseSize());
    }

    @Override
    protected void registerListeners() {
        this.addNumberVerification(this.txtConnectionTimeout, 0, 9999999, true, "");
        this.addNumberVerification(this.txtSocketTimeout, 0, 9999999, true, "");
        this.addNumberVerification(this.txtResponseSizeLimit, 0, Integer.MAX_VALUE, true, "");
        this.addButtonDefaultSelectionListener(this.checkboxFollowRedirects);
        if (!this.canCustomizeRequestTimeout()) {
            this.productFeatureDialog.showNotAvailableFeature(ProductFeature.CUSTOM_WEB_SERVICE_REQUEST_TIMEOUT);
        }
    }

    @Override
    protected void initialize() throws IOException {
        long responseSizeLimit;
        boolean isDefaultResponseSizeLimit;
        int socketTimeout;
        boolean isDefaultSocketTimeout;
        boolean isDefaultConnectionTimeout;
        int connectionTimeout = this.webServiceSettingStore.getConnectionTimeout();
        boolean bl = isDefaultConnectionTimeout = connectionTimeout == 0;
        if (!isDefaultConnectionTimeout) {
            this.txtConnectionTimeout.setText(String.valueOf(connectionTimeout));
        }
        boolean bl2 = isDefaultSocketTimeout = (socketTimeout = this.webServiceSettingStore.getSocketTimeout()) == 0;
        if (!isDefaultSocketTimeout) {
            this.txtSocketTimeout.setText(String.valueOf(socketTimeout));
        }
        boolean bl3 = isDefaultResponseSizeLimit = (responseSizeLimit = this.webServiceSettingStore.getMaxResponseSize()) == 0L;
        if (!isDefaultResponseSizeLimit) {
            this.txtResponseSizeLimit.setText(String.valueOf(responseSizeLimit));
        }
        boolean followRedirects = this.webServiceSettingStore.getFollowRedirects();
        this.checkboxFollowRedirects.setSelection(followRedirects);
    }

    @Override
    protected void performDefaults() {
        if (!this.canCustomizeRequestTimeout()) {
            return;
        }
        this.txtConnectionTimeout.setText("");
        this.txtSocketTimeout.setText("");
        this.txtResponseSizeLimit.setText("");
        this.checkboxFollowRedirects.setSelection(true);
        super.performDefaults();
    }

    @Override
    protected boolean saveSettings() {
        if (!this.isValid()) {
            return false;
        }
        try {
            int connectionTimeout = StringUtils.isNotBlank((String)this.txtConnectionTimeout.getText()) ? Integer.parseInt(this.txtConnectionTimeout.getText()) : 0;
            this.webServiceSettingStore.setConnectionTimeout(connectionTimeout);
            int socketTimeout = StringUtils.isNotBlank((String)this.txtSocketTimeout.getText()) ? Integer.parseInt(this.txtSocketTimeout.getText()) : 0;
            this.webServiceSettingStore.setSocketTimeout(socketTimeout);
            long responseSizeLimit = StringUtils.isNotBlank((String)this.txtResponseSizeLimit.getText()) ? (long)Integer.parseInt(this.txtResponseSizeLimit.getText()) : 0L;
            this.webServiceSettingStore.setMaxResponseSize(responseSizeLimit);
            boolean isFollowRedirectsEnabled = this.checkboxFollowRedirects.getSelection();
            boolean isFollowRedirectsChanged = this.webServiceSettingStore.getFollowRedirects() ^ isFollowRedirectsEnabled;
            this.webServiceSettingStore.setFollowRedirects(isFollowRedirectsEnabled);
            if (isFollowRedirectsChanged) {
                Trackings.trackEnableFollowRedirectsConfiguration((boolean)isFollowRedirectsEnabled);
            }
        }
        catch (IOException exception) {
            LoggerSingleton.logError((Throwable)exception, (String)"saveSettings failed with exception");
            return false;
        }
        return true;
    }

    @Override
    protected boolean hasChanged() {
        if (!this.isValid()) {
            return false;
        }
        try {
            int originalConnectionTimeout = this.webServiceSettingStore.getConnectionTimeout();
            int currentConnectionTimeout = StringUtils.isNotBlank((String)this.txtConnectionTimeout.getText()) ? Integer.parseInt(this.txtConnectionTimeout.getText()) : 0;
            boolean hasConnectionTimeoutChanged = currentConnectionTimeout != originalConnectionTimeout;
            int originalSocketTimeout = this.webServiceSettingStore.getSocketTimeout();
            int currentSocketTimeout = StringUtils.isNotBlank((String)this.txtSocketTimeout.getText()) ? Integer.parseInt(this.txtSocketTimeout.getText()) : 0;
            boolean hasSocketTimeoutChanged = currentSocketTimeout != originalSocketTimeout;
            long originalResponseSizeLimit = this.webServiceSettingStore.getMaxResponseSize();
            long currentResponseSizeLimit = StringUtils.isNotBlank((String)this.txtResponseSizeLimit.getText()) ? (long)Integer.parseInt(this.txtResponseSizeLimit.getText()) : 0L;
            boolean hasResponseSizeLimitChanged = currentResponseSizeLimit != originalResponseSizeLimit;
            boolean originalFollowRedirects = this.webServiceSettingStore.getFollowRedirects();
            boolean currentFollowRedirects = this.checkboxFollowRedirects.getSelection();
            boolean hasFollowRedirectsChanged = originalFollowRedirects ^ currentFollowRedirects;
            return hasConnectionTimeoutChanged || hasSocketTimeoutChanged || hasResponseSizeLimitChanged || hasFollowRedirectsChanged;
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e, (String)"hasChanged failed with exception");
            return false;
        }
    }

    private boolean canCustomizeRequestTimeout() {
        return this.featureController.canUse(ProductFeature.CUSTOM_WEB_SERVICE_REQUEST_TIMEOUT);
    }

    private boolean canCustomizeResponseSize() {
        return this.featureController.canUse(ProductFeature.CUSTOM_WEB_SERVICE_RESPONSE_SIZE_LIMIT);
    }
}

