/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.trace;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.execution.constants.ComposerExecutionMessageConstants;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.composer.execution.trace.ArtifactStyleRangeMatcher;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.WindowsElementController;
import com.kms.katalon.entity.repository.MobileElementEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.repository.WindowsElementEntity;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class TestObjectStyleRangeMatcher
extends ArtifactStyleRangeMatcher {
    private static final String TEST_OBJECT_ID_PATTERN = "'Object Repository\\/([^']*)'";

    @Override
    public String getPattern() {
        return TEST_OBJECT_ID_PATTERN;
    }

    @Override
    protected void internalClick(String testObjectId) {
        WebElementEntity webElement = this.getTestObject(testObjectId);
        if (webElement != null) {
            String eventName = "TESTOBJECT/OPEN";
            if (webElement instanceof MobileElementEntity) {
                eventName = "MOBILE_TESTOBJECT/OPEN";
            } else if (webElement instanceof WebServiceRequestEntity) {
                eventName = "WSOBJECT/OPEN";
            }
            EventBrokerSingleton.getInstance().getEventBroker().post(eventName, (Object)webElement);
        } else {
            WindowsElementEntity windowsElement = this.getWindowsObject(testObjectId);
            if (windowsElement != null) {
                EventBrokerSingleton.getInstance().getEventBroker().post("WINDOWS_TEST_OBJECT/OPEN", (Object)webElement);
            } else {
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.WARN, (String)MessageFormat.format(ComposerExecutionMessageConstants.WARN_TEST_OBEJCT_NOT_FOUND, testObjectId));
            }
        }
    }

    private WebElementEntity getTestObject(String testObjectId) {
        WebElementEntity webElement = null;
        try {
            webElement = ObjectRepositoryController.getInstance().getWebElementByDisplayPk(testObjectId);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return webElement;
    }

    private WindowsElementEntity getWindowsObject(String testObjectId) {
        WindowsElementEntity windowsElement = null;
        try {
            windowsElement = WindowsElementController.getInstance().getWindowsElementByDisplayId(testObjectId);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return windowsElement;
    }
}

