/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.util;

import com.kms.katalon.composer.execution.launcher.IDEObservableLauncher;
import com.kms.katalon.composer.execution.launcher.IDEObservableParentLauncher;
import com.kms.katalon.core.logging.XmlLogRecord;
import com.kms.katalon.core.util.NodeFinder;
import com.kms.katalon.core.util.NodeUtils;
import com.kms.katalon.execution.launcher.ILauncher;
import com.kms.katalon.execution.launcher.result.LauncherStatus;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class LauncherHelper {
    private static final EnumSet<LauncherStatus> NON_RUNNING_STATUSES = EnumSet.of(LauncherStatus.DONE, LauncherStatus.TERMINATED, LauncherStatus.SUSPENDED);
    private static NodeUtils.ChildrenNodeProvider<ILauncher> SUB_LAUNCHERS_PROVIDER = launcher -> {
        List<ILauncher> list;
        if (launcher instanceof IDEObservableParentLauncher) {
            IDEObservableParentLauncher parentLauncher = (IDEObservableParentLauncher)launcher;
            list = LauncherHelper.toLaunchers(parentLauncher.getObservableLaunchers());
        } else {
            list = null;
        }
        return list;
    };

    public static IDEObservableLauncher findObservedLauncher(List<ILauncher> launchers) {
        return (IDEObservableLauncher)LauncherHelper.findLauncher(launchers, (NodeUtils.NodeVerifier<ILauncher>)((NodeUtils.NodeVerifier)launcher -> {
            IDEObservableLauncher observableLauncher;
            return launcher instanceof IDEObservableLauncher && (observableLauncher = (IDEObservableLauncher)launcher).isObserved();
        }));
    }

    public static IDEObservableLauncher findLauncher(ILauncher root, String launcherId) {
        return (IDEObservableLauncher)LauncherHelper.findLauncher(root, (NodeUtils.NodeVerifier<ILauncher>)((NodeUtils.NodeVerifier)launcher -> launcher instanceof IDEObservableLauncher && LauncherHelper.isSameLauncher(launcher, launcherId)));
    }

    public static IDEObservableLauncher findLauncher(List<ILauncher> launchers, String launcherId) {
        return (IDEObservableLauncher)LauncherHelper.findLauncher(launchers, (NodeUtils.NodeVerifier<ILauncher>)((NodeUtils.NodeVerifier)launcher -> launcher instanceof IDEObservableLauncher && LauncherHelper.isSameLauncher(launcher, launcherId)));
    }

    public static <LauncherType extends ILauncher> LauncherType findLauncher(ILauncher root, NodeUtils.NodeVerifier<ILauncher> finder) {
        NodeFinder nodeFinder = new NodeFinder();
        nodeFinder.finder = finder;
        nodeFinder.childrenProvider = SUB_LAUNCHERS_PROVIDER;
        return (LauncherType)((ILauncher)nodeFinder.find((Object)root));
    }

    public static <LauncherType extends ILauncher> LauncherType findLauncher(Iterable<ILauncher> launchers, NodeUtils.NodeVerifier<ILauncher> finder) {
        NodeFinder nodeFinder = new NodeFinder();
        nodeFinder.finder = finder;
        nodeFinder.childrenProvider = SUB_LAUNCHERS_PROVIDER;
        return (LauncherType)((ILauncher)nodeFinder.find(launchers));
    }

    public static boolean isSameLauncher(ILauncher launcherA, ILauncher launcherB) {
        return launcherA == launcherB || launcherA != null && launcherB != null && LauncherHelper.isSameLauncher(launcherA.getId(), launcherB.getId());
    }

    public static boolean isSameLauncher(String launcherAId, String launcherBId) {
        return StringUtils.equals((CharSequence)launcherAId, (CharSequence)launcherBId);
    }

    public static boolean isSameLauncher(ILauncher launcherA, String launcherBId) {
        return launcherA == null && launcherBId == null || launcherA != null && StringUtils.equals((CharSequence)launcherA.getId(), (CharSequence)launcherBId);
    }

    public static List<ILauncher> toLaunchers(List<IDEObservableLauncher> observableLaunchers) {
        return observableLaunchers.stream().map(launcherI -> launcherI).collect(Collectors.toList());
    }

    public static boolean setObservedLauncher(String launcherId, List<ILauncher> launchers) {
        boolean foundSelectedChild = false;
        for (ILauncher launcher : launchers) {
            if (!(launcher instanceof IDEObservableLauncher)) continue;
            IDEObservableLauncher observableLauncher = (IDEObservableLauncher)launcher;
            boolean isSameId = StringUtils.equals((CharSequence)launcher.getId(), (CharSequence)launcherId);
            if (isSameId) {
                foundSelectedChild = true;
                observableLauncher.setObserved(true);
                continue;
            }
            observableLauncher.setObserved(false);
            if (!(launcher instanceof IDEObservableParentLauncher)) continue;
            IDEObservableParentLauncher parentLauncher = (IDEObservableParentLauncher)launcher;
            List<ILauncher> subLaunchers = LauncherHelper.toLaunchers(parentLauncher.getObservableLaunchers());
            boolean isSubLauncherSelected = LauncherHelper.setObservedLauncher(launcherId, subLaunchers);
            observableLauncher.setObserved(isSubLauncherSelected);
            if (!isSubLauncherSelected) continue;
            foundSelectedChild = true;
        }
        return foundSelectedChild;
    }

    public static boolean isNonRunningLauncher(ILauncher launcher) {
        LauncherStatus status = launcher.getStatus();
        return status != null && NON_RUNNING_STATUSES.contains(status);
    }

    public static boolean isPendingLauncher(IDEObservableLauncher launcher) {
        if (launcher == null) {
            return false;
        }
        List<XmlLogRecord> logRecods = launcher.getLogRecords();
        return logRecods == null || logRecods.isEmpty();
    }
}

