/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.processors;

import java.util.ArrayList;
import java.util.List;
import org.apache.groovy.util.BeanUtils;
import org.codehaus.groovy.eclipse.codeassist.GroovyContentAssist;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.processors.AbstractGroovyCompletionProcessor;
import org.codehaus.groovy.eclipse.codeassist.relevance.Relevance;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.codeassist.impl.AssistOptions;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.ui.text.java.GetterSetterCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class GetSetMethodCompletionProcessor
extends AbstractGroovyCompletionProcessor {
    public GetSetMethodCompletionProcessor(ContentAssistContext context, JavaContentAssistInvocationContext javaContext, SearchableEnvironment nameEnvironment) {
        super(context, javaContext, nameEnvironment);
    }

    @Override
    public List<ICompletionProposal> generateProposals(IProgressMonitor monitor) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        ContentAssistContext context = this.getContext();
        IType enclosingType = context.getEnclosingType();
        if (enclosingType != null) {
            AssistOptions options = new AssistOptions(this.getJavaContext().getProject().getOptions(true));
            int length = context.completionExpression.length();
            int offset = context.completionLocation - length;
            try {
                IField[] iFieldArray = enclosingType.getFields();
                int n = iFieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IField field = iFieldArray[n2];
                    if (field.getSourceRange().getLength() > 0 && !field.isEnumConstant() && !GetSetMethodCompletionProcessor.isRecordComponent(field) && ProposalUtils.matches(context.completionExpression, BeanUtils.capitalize((String)field.getElementName()), options.camelCaseMatch, options.subwordMatch)) {
                        IMethod setter;
                        IMethod getter = GetterSetterUtil.getGetter((IField)field);
                        if (getter == null || !getter.exists()) {
                            proposals.add((ICompletionProposal)new GetterSetterCompletionProposal(field, offset, length, true, Relevance.HIGH.getRelevance()));
                        }
                        if (!(Flags.isFinal((int)field.getFlags()) || (setter = GetterSetterUtil.getSetter((IField)field)) != null && setter.exists())) {
                            proposals.add((ICompletionProposal)new GetterSetterCompletionProposal(field, offset, length, false, Relevance.HIGH.getRelevance()));
                        }
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                GroovyContentAssist.logError("Exception looking for proposal providers in " + context.unit.getElementName(), e);
            }
        }
        return proposals;
    }

    private static boolean isRecordComponent(IField field) throws JavaModelException {
        return !Flags.isStatic((int)field.getFlags()) && (field.getDeclaringType().getFlags() & 0x1000000) != 0;
    }
}

