/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.collector;

import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.core.testobject.BrokenTestObject;
import com.kms.katalon.core.testobject.BrokenTestObjects;
import com.kms.katalon.core.webui.common.internal.SelfHealingController;
import com.kms.katalon.execution.collector.SelfHealingExecutionReport;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class SelfHealingExecutionReportCollector {
    private static SelfHealingExecutionReportCollector _instance;

    public static SelfHealingExecutionReportCollector getInstance() {
        if (_instance == null) {
            _instance = new SelfHealingExecutionReportCollector();
        }
        return _instance;
    }

    public SelfHealingExecutionReport collect(IRunConfiguration runConfig, File reportFolder) {
        Map generalProperties = runConfig.getExecutionSetting().getGeneralProperties();
        boolean isSelfHealingEnabled = this.isWebUiSelfHealingEnabled(generalProperties) || this.isMobileSelfHealingEnabled(generalProperties);
        return this.collect(isSelfHealingEnabled, reportFolder);
    }

    private boolean isWebUiSelfHealingEnabled(Map<String, Object> generalProperties) {
        return this.getBooleanProperty(generalProperties, "selfHealingEnabled");
    }

    private boolean isMobileSelfHealingEnabled(Map<String, Object> generalProperties) {
        return this.getBooleanProperty(generalProperties, "mobileSelfHealingEnabled");
    }

    private boolean getBooleanProperty(Map<String, Object> properties, String key) {
        if (properties == null || properties.get(key) == null) {
            return false;
        }
        return Boolean.TRUE.equals(properties.get(key));
    }

    public SelfHealingExecutionReport collect(boolean isSelfHealingEnabled, File reportFolder) {
        ArrayList selfHealingDataFiles = new ArrayList();
        try {
            Files.walk(Paths.get(reportFolder.getAbsolutePath(), new String[0]), new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0])).forEach(selfHealingDataFile -> {
                String fileName = selfHealingDataFile.getFileName().toString();
                if (StringUtils.equals((CharSequence)fileName, (CharSequence)"broken-test-objects-v2.json")) {
                    selfHealingDataFiles.add(selfHealingDataFile.toFile());
                }
            });
        }
        catch (IOException error) {
            LogUtil.logError((Throwable)error);
        }
        boolean isTriggered = selfHealingDataFiles != null && !selfHealingDataFiles.isEmpty();
        HashSet<BrokenTestObject> brokenTestObjects = new HashSet<BrokenTestObject>();
        selfHealingDataFiles.stream().forEach(dataFile -> {
            Set<BrokenTestObject> pratialBrokenTestObjects = this.collectBrokenTestObjects(dataFile.getParentFile());
            if (pratialBrokenTestObjects != null) {
                brokenTestObjects.addAll(pratialBrokenTestObjects);
            }
        });
        return new SelfHealingExecutionReport(isSelfHealingEnabled, isTriggered, brokenTestObjects);
    }

    public Set<BrokenTestObject> collectBrokenTestObjects(File reportFolder) {
        BrokenTestObjects brokenTestObjectsWrapper;
        String selfHealingDataFilePath = SelfHealingController.getSelfHealingDataFilePath((String)reportFolder.getAbsolutePath());
        boolean isTriggered = new File(selfHealingDataFilePath).exists();
        Set brokenTestObjects = null;
        if (isTriggered && (brokenTestObjectsWrapper = SelfHealingController.readExistingBrokenTestObjects((String)selfHealingDataFilePath)) != null) {
            brokenTestObjects = brokenTestObjectsWrapper.getBrokenTestObjects();
        }
        return brokenTestObjects;
    }
}

