/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.configuration;

import com.kms.katalon.configuration.core.interfaces.IDriverConnector;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.util.ApplicationRunningMode;
import com.kms.katalon.execution.collector.DriverConnectorCollector;
import com.kms.katalon.execution.collector.RunConfigurationCollector;
import com.kms.katalon.execution.configuration.AbstractRunConfiguration;
import com.kms.katalon.execution.configuration.contributor.IRunConfigurationContributor;
import com.kms.katalon.execution.configuration.impl.CustomExecutionSetting;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class CustomRunConfiguration
extends AbstractRunConfiguration {
    private String name;
    private Map<String, IDriverConnector> driverConnectors;
    private Map<String, IRunConfiguration> runConfigurations;
    private File configFolder;
    protected String projectDir;
    public static final String REMOTE_WEB_DRIVER_URL = "remoteWebDriverUrl";

    public CustomRunConfiguration(String projectDir, String name) throws IOException, ExecutionException {
        this.name = name;
        this.projectDir = projectDir;
        this.initConfigFolder(projectDir);
        this.doInitExecutionSetting();
    }

    private void initConfigFolder(String projectFolderLocation) throws IOException, ExecutionException {
        this.setConfigFolder(this.getConfigFolder(projectFolderLocation));
        this.initDriverConnectors();
    }

    @Override
    protected void setupConfiguration() {
        this.initVmArguments();
    }

    @Override
    protected void initExecutionSetting() {
        this.executionSetting = new CustomExecutionSetting(this.driverConnectors);
        ContextInjectionFactory.inject((Object)this.executionSetting, (IEclipseContext)this.context);
    }

    public IRunConfiguration cloneConfig() throws IOException, ExecutionException {
        return new CustomRunConfiguration(this.projectDir, this.name);
    }

    private void initDriverConnectors() throws IOException, ExecutionException {
        this.driverConnectors = new LinkedHashMap<String, IDriverConnector>();
        this.runConfigurations = new HashMap<String, IRunConfiguration>();
        if (this.configFolder == null || !this.configFolder.exists()) {
            return;
        }
        ScopedPreferenceStore store = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.core.webui");
        boolean isUpdateDriverAllowed = store.getBoolean("webui.autoUpdateDrivers");
        boolean isEnableAutoUpdateDrivers = isUpdateDriverAllowed && ApplicationRunningMode.get() == RunningMode.CONSOLE;
        this.driverConnectors = DriverConnectorCollector.getInstance().getDriverConnectors(this.getConfigFolder());
        for (IDriverConnector driverConnector : this.driverConnectors.values()) {
            String driverName = driverConnector.getDriverType().toString();
            IRunConfigurationContributor contributor = RunConfigurationCollector.getInstance().getRunContributor(driverName);
            try {
                IRunConfiguration runConfig = contributor.getRunConfiguration(this.projectDir, driverConnector);
                if (runConfig == null) continue;
                this.runConfigurations.put(driverName, runConfig);
                if (!isEnableAutoUpdateDrivers) continue;
                Map newDriverConnectors = runConfig.getDriverConnectors();
                for (Map.Entry entry : newDriverConnectors.entrySet()) {
                    Map properties = ((IDriverConnector)entry.getValue()).getSystemProperties();
                    driverConnector.updateSystemProperties(properties);
                }
            }
            catch (Exception exception) {}
        }
    }

    private File getConfigFolder(String projectFolderLocation) {
        return new File(projectFolderLocation + File.separator + RunConfigurationCollector.CUSTOM_EXECUTION_CONFIG_ROOT_FOLDER_RELATIVE_PATH + File.separator + this.name);
    }

    public Map<String, IDriverConnector> getDriverConnectors() {
        return this.driverConnectors;
    }

    public void clearAllDriverConnectors() {
        this.driverConnectors.clear();
    }

    public void addDriverConnector(String contributorName, IDriverConnector driverConnector) {
        if (driverConnector == null) {
            return;
        }
        this.driverConnectors.put(contributorName, driverConnector);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) throws IOException, ExecutionException {
        this.name = name;
        this.configFolder = this.getConfigFolder(this.getProjectFolderLocation());
        for (IDriverConnector driverConnector : this.driverConnectors.values()) {
            driverConnector.setParentFolderPath(this.configFolder.getAbsolutePath());
        }
    }

    @Override
    public String getRemoteDomain() {
        String remoteServerUrl;
        IDriverConnector driver = this.getDriverConnectors().get("Remote");
        if (driver == null) {
            return "";
        }
        Object remoteWebDriver = driver.getSystemProperties().get(REMOTE_WEB_DRIVER_URL);
        String string = remoteServerUrl = remoteWebDriver instanceof String ? (String)remoteWebDriver : null;
        if (StringUtils.isBlank((String)remoteServerUrl)) {
            return "";
        }
        try {
            URI uri = new URI(remoteServerUrl);
            return uri.getHost();
        }
        catch (URISyntaxException e) {
            LogUtil.logError((String)"Failed to retrieve custom remote URL");
            LogUtil.logError((Throwable)e);
            LogUtil.logError((String)"Return empty remote URL");
            return "";
        }
    }

    @Override
    public String getReportDriverName() {
        IDriverConnector driver = this.getDriverConnectors().get("Remote");
        boolean isRemoteDriver = driver != null;
        return isRemoteDriver ? MessageFormat.format("Custom - {0} - {1}", super.getName(), driver.getSystemProperties().get("remoteWebDriverType")) : MessageFormat.format("Custom - {0}", super.getName());
    }

    public void save() throws IOException {
        if (!this.configFolder.exists()) {
            this.configFolder.mkdirs();
        }
        for (IDriverConnector driverConnector : this.driverConnectors.values()) {
            driverConnector.saveUserConfigProperties();
        }
    }

    public void delete() throws IOException {
        if (this.configFolder.exists()) {
            FileUtils.deleteDirectory((File)this.configFolder);
        }
    }

    public File getConfigFolder() {
        return this.configFolder;
    }

    public void setConfigFolder(File configFolder) {
        this.configFolder = configFolder;
    }

    public String toString() {
        StringBuilder valueString = new StringBuilder();
        boolean isFirst = true;
        for (IDriverConnector driverConnector : this.getDriverConnectors().values()) {
            if (!isFirst) {
                valueString.append(" + ");
            } else {
                isFirst = false;
            }
            valueString.append(driverConnector.getDriverType().toString() + ": " + driverConnector.toString());
        }
        return valueString.toString();
    }

    @Override
    public Map<String, String> getAdditionalEnvironmentVariables() throws IOException, ExecutionException {
        HashMap<String, String> environmentVariables = new HashMap<String, String>(super.getAdditionalEnvironmentVariables());
        for (IRunConfiguration runConfig : this.runConfigurations.values()) {
            environmentVariables.putAll(runConfig.getAdditionalEnvironmentVariables());
        }
        return environmentVariables;
    }
}

