/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.configuration.impl;

import com.katalon.capability.constant.DriverPlatform;
import com.kms.katalon.configuration.core.interfaces.IDriverConnector;
import com.kms.katalon.core.enums.mobile.MobilePlatform;
import com.kms.katalon.execution.configuration.impl.DefaultExecutionSetting;
import com.kms.katalon.execution.setting.MobileSettingStore;
import com.kms.katalon.execution.setting.WebUiExecutionSettingStore;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class RemoteExecutionSetting
extends DefaultExecutionSetting {
    @Inject
    private IFeatureController featureController;
    private IDriverConnector driverConnector;
    private DriverPlatform platform;

    public RemoteExecutionSetting(IDriverConnector driverConnector) {
        this.driverConnector = driverConnector;
        this.platform = this.determinePlatform(driverConnector);
        if (this.platform == DriverPlatform.MOBILE) {
            this.setTimeout(MobileSettingStore.getStore().safelyGetElementTimeout());
        } else {
            this.setTimeout(WebUiExecutionSettingStore.getStore().safelyGetElementTimeout());
        }
    }

    private DriverPlatform determinePlatform(IDriverConnector driverConnector) {
        String remoteWebDriverType;
        if (driverConnector != null && (remoteWebDriverType = (String)driverConnector.getSystemProperties().get("remoteWebDriverType")) != null && "appium".equals(remoteWebDriverType.toLowerCase())) {
            return DriverPlatform.MOBILE;
        }
        return DriverPlatform.WEB;
    }

    @Override
    public Map<String, Object> getGeneralProperties() {
        Map<String, Object> generalProperties = super.getGeneralProperties();
        generalProperties.putAll(this.getRemoteExecutionProperties());
        return generalProperties;
    }

    private Map<String, Object> getRemoteExecutionProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (this.driverConnector != null) {
            Map systemProps = this.driverConnector.getSystemProperties();
            String remoteWebDriverType = (String)systemProps.get("remoteWebDriverType");
            if (remoteWebDriverType != null && "selenium".equals(remoteWebDriverType.toLowerCase())) {
                props.putAll(this.getWebUiExecutionProperties());
            } else if (remoteWebDriverType != null && "appium".equals(remoteWebDriverType.toLowerCase())) {
                props.putAll(this.getMobileExecutionProperties());
            }
        }
        return props;
    }

    private Map<String, Object> getWebUiExecutionProperties() {
        WebUiExecutionSettingStore webUiSettingStore = WebUiExecutionSettingStore.getStore();
        HashMap<String, Object> props = new HashMap<String, Object>();
        try {
            props.put("timeout", webUiSettingStore.getElementTimeout());
            props.put("enablePageLoadTimeout", webUiSettingStore.getEnablePageLoadTimeout());
            props.put("defaultPageLoadTimeout", webUiSettingStore.getPageLoadTimeout());
            props.put("actionDelay", webUiSettingStore.getActionDelay());
            props.put("useActionDelayInSecond", (Object)webUiSettingStore.getUseDelayActionTimeUnit());
            props.put("ignorePageLoadTimeoutException", webUiSettingStore.getIgnorePageLoadTimeout());
            props.put("excludeKeywords", webUiSettingStore.getExcludeKeywordList());
            props.put("methodsPriorityOrder", webUiSettingStore.getMethodsPriorityOrder());
            props.put("selfHealingEnabled", webUiSettingStore.getSelfHealingEnabled(this.canUseSelfHealing()));
            props.put("timeCapsuleEnabled", webUiSettingStore.getTimeCapsuleEnabled());
            props.put("flutterAppTestingEnabled", webUiSettingStore.isEnableFlutterAppTesting());
            props.put("canvasTextExtractionEnabled", webUiSettingStore.isEnableCanvasTextExtraction());
            props.put("closedShadowDOMEnabled", webUiSettingStore.isEnableClosedShadowDOMTesting());
            props.put("xpathsPriority", webUiSettingStore.getCapturedTestObjectXpathLocators());
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
        return props;
    }

    private Map<String, Object> getMobileExecutionProperties() {
        MobileSettingStore mobileSettingStore = MobileSettingStore.getStore();
        HashMap<String, Object> props = new HashMap<String, Object>();
        try {
            props.put("timeout", mobileSettingStore.getElementTimeout());
            props.put("mobileSelfHealingEnabled", mobileSettingStore.getSelfHealingEnabled(this.canUseSelfHealing()));
            props.put("excludeMobileKeywords", mobileSettingStore.getExcludedKeywords());
            props.put("prioritizedLocatorStrategiesForAndroid", mobileSettingStore.getPrioritizedLocatorStrategies(MobilePlatform.ANDROID));
            props.put("prioritizedLocatorStrategiesForIos", mobileSettingStore.getPrioritizedLocatorStrategies(MobilePlatform.IOS));
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
        return props;
    }

    private boolean canUseSelfHealing() {
        return this.featureController.canUse(ProductFeature.SELF_HEALING);
    }
}

