/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.entity;

import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.console.entity.ConsoleOptionContributor;
import com.kms.katalon.execution.console.entity.StringConsoleOption;
import com.kms.katalon.execution.entity.EmailConfig;
import com.kms.katalon.execution.util.MailUtil;
import java.util.ArrayList;
import java.util.List;

public class EmailSettings
implements ConsoleOptionContributor {
    public static final String SEND_EMAIL_OPTION = "sendMail";
    private static ConsoleOption<String> sendEmailConsoleOption = new StringConsoleOption(){

        @Override
        public String getOption() {
            return EmailSettings.SEND_EMAIL_OPTION;
        }
    };
    private EmailConfig emailConfig;

    @Override
    public List<ConsoleOption<?>> getConsoleOptionList() {
        ArrayList consoleOptions = new ArrayList();
        consoleOptions.add(sendEmailConsoleOption);
        return consoleOptions;
    }

    public EmailConfig getEmailConfig(ProjectEntity project) {
        if (this.emailConfig == null) {
            this.emailConfig = MailUtil.getDefaultEmailConfig(project);
        }
        return this.emailConfig;
    }

    public EmailConfig getEmailConfig() {
        return this.emailConfig;
    }

    public void setEmailConfig(EmailConfig emailConfig) {
        this.emailConfig = emailConfig;
    }

    @Override
    public void setArgumentValue(ConsoleOption<?> consoleOption, String argumentValue) throws Exception {
        if (consoleOption == sendEmailConsoleOption) {
            EmailConfig currentEmailConfig = this.getEmailConfig(ProjectController.getInstance().getCurrentProject());
            if (currentEmailConfig == null) {
                return;
            }
            currentEmailConfig.addRecipients(argumentValue);
        }
    }
}

