/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.finders;

import com.kms.katalon.core.testdata.TestData;
import com.kms.katalon.entity.link.TestDataCombinationType;
import com.kms.katalon.entity.link.VariableLink;
import com.kms.katalon.execution.core.interfaces.IExecutedEntity;
import com.kms.katalon.execution.entity.ExecutedEntity;
import com.kms.katalon.execution.entity.TestCaseBindingExecutedEntity;
import com.kms.katalon.execution.entity.TestCaseExecutedEntity;
import com.kms.katalon.execution.entity.TestDataExecutedEntity;
import com.kms.katalon.execution.exception.SyntaxErrorException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class TestDataValueFinder {
    private VariableLink variableLink;
    private Map<String, TestData> testDataMap;
    private IExecutedEntity executedEntity;

    protected TestDataValueFinder(VariableLink variableLink, Map<String, TestData> testDataMap, IExecutedEntity executedEntity) {
        this.variableLink = variableLink;
        this.testDataMap = testDataMap;
        this.executedEntity = executedEntity;
    }

    protected abstract int getColumnIndex(TestData var1) throws SyntaxErrorException, IOException;

    public Object getVariableValue(String errorMsg, int iterationIdx) throws SyntaxErrorException, IOException {
        String testDataLinkId = this.variableLink.getTestDataLinkId();
        if (StringUtils.isEmpty((String)testDataLinkId)) {
            throw new SyntaxErrorException(errorMsg);
        }
        List<TestDataExecutedEntity> testDataExecutions = null;
        if (this.executedEntity instanceof TestCaseExecutedEntity) {
            testDataExecutions = ((TestCaseExecutedEntity)this.executedEntity).getTestDataExecutions();
        } else if (this.executedEntity instanceof TestCaseBindingExecutedEntity) {
            testDataExecutions = ((TestCaseBindingExecutedEntity)this.executedEntity).getTestDataExecutions();
        } else {
            return null;
        }
        TestDataExecutedEntity testDataExecutedEntity = ((ExecutedEntity)this.executedEntity).getTestDataExecuted(this.variableLink.getTestDataLinkId(), testDataExecutions);
        TestData testData = this.testDataMap.get(testDataExecutedEntity.getTestDataId());
        int rowIndex = this.getRowIndex(testDataExecutedEntity, iterationIdx);
        return testData.getObjectValue(this.getColumnIndex(testData), rowIndex);
    }

    private int getRowIndex(TestDataExecutedEntity testDataExecutedEntity, int iterationIdx) {
        int rowIndex = 0;
        rowIndex = testDataExecutedEntity.getType() == TestDataCombinationType.ONE ? iterationIdx % testDataExecutedEntity.getRowIndexes().length : iterationIdx / testDataExecutedEntity.getMultiplier() % testDataExecutedEntity.getRowIndexes().length;
        return testDataExecutedEntity.getRowIndexes()[rowIndex];
    }
}

