/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.launcher;

import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.entity.testsuite.RunConfigurationDescription;
import com.kms.katalon.execution.configuration.AbstractRunConfiguration;
import com.kms.katalon.execution.configuration.contributor.IRunConfigurationContributor;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.execution.core.interfaces.IExecutedEntity;
import com.kms.katalon.execution.launcher.BasicLauncher;
import com.kms.katalon.execution.launcher.IWatchdogListener;
import com.kms.katalon.execution.launcher.IWatcher;
import com.kms.katalon.execution.launcher.LaunchWatchdog;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.launcher.process.ILaunchProcess;
import com.kms.katalon.execution.launcher.result.ExecutionEntityResult;
import com.kms.katalon.execution.launcher.result.ILauncherResult;
import com.kms.katalon.execution.launcher.result.LauncherResult;
import com.kms.katalon.execution.launcher.result.LauncherStatus;
import com.kms.katalon.execution.logging.IOutputStream;
import com.kms.katalon.execution.util.ExecutionExceptionUtil;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class ProcessLauncher
extends BasicLauncher
implements IWatchdogListener {
    protected IRunConfigurationContributor runConfigContributor;
    protected RunConfigurationDescription runConfigurationDescription;
    protected String projectDir;
    protected IRunConfiguration runConfig;
    private ILauncherResult result;
    protected IExecutedEntity executedEntity;
    protected Set<IWatcher> watchers = new HashSet<IWatcher>();
    protected LaunchWatchdog watchdog;
    protected ILaunchProcess process;
    private LauncherManager manager;
    protected BasicLauncher parentLauncher;

    private ProcessLauncher() {
    }

    protected ProcessLauncher(IRunConfiguration runConfig) {
        this();
        this.setRunConfig(runConfig);
    }

    protected ProcessLauncher(LauncherManager manager, IRunConfiguration runConfig) {
        this(runConfig);
        this.manager = manager;
    }

    public void configureToLazilyRebuildRunConfigDriverConnector(IRunConfigurationContributor runConfigContributor, String projectDir, RunConfigurationDescription runConfigDescription) {
        this.runConfigContributor = runConfigContributor;
        this.projectDir = projectDir;
        this.runConfigurationDescription = runConfigDescription;
    }

    public void rebuildRunConfigDriverConnector() {
        if (this.runConfigContributor == null || StringUtils.isBlank((CharSequence)this.projectDir) || this.runConfigurationDescription == null) {
            return;
        }
        try {
            AbstractRunConfiguration newRunConfig = (AbstractRunConfiguration)this.runConfigContributor.getRunConfiguration(this.projectDir, this.runConfigurationDescription);
            ((AbstractRunConfiguration)this.runConfig).copyDriverConnectorsFrom(newRunConfig);
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e, (String)"Failed to rebuild runConfig's driverConnector");
        }
    }

    protected LauncherManager getManager() {
        return this.manager;
    }

    protected void setManager(LauncherManager manager) {
        this.manager = manager;
    }

    @Override
    public final String getId() {
        return this.getRunConfig().getExecutionSetting().getName();
    }

    @Override
    public String getName() {
        return this.executedEntity.getSourceId() + " - " + this.getRunConfig().getName() + " - " + this.getId();
    }

    public IRunConfiguration getRunConfig() {
        return this.runConfig;
    }

    @Override
    public ILauncherResult getResult() {
        return this.result;
    }

    @Override
    public void setStatus(LauncherStatus status) {
        super.setStatus(status);
        ExecutionEntityResult executionResult = new ExecutionEntityResult();
        if ((LauncherStatus.DONE == status || LauncherStatus.TERMINATED == status) && this.parentLauncher == null) {
            executionResult.setEnd(true);
        }
        this.notifyProccess((Object)status, this.executedEntity, executionResult);
    }

    @Override
    public final void start() {
        this.onStartExecution();
        this.watchdog = new LaunchWatchdog(this.watchers.toArray(new IWatcher[this.watchers.size()]));
        this.watchdog.addListener(this);
        Thread mainThread = new Thread(this.watchdog);
        mainThread.start();
        try {
            this.process = this.launch();
            if (this.process != null) {
                this.watchdog.setProcess(this.process);
                this.onStartExecutionComplete();
            } else {
                this.stop();
            }
        }
        catch (ExecutionException e) {
            String longPathErrorMessage = ExecutionExceptionUtil.getLongPathErrorMessage(e);
            if (StringUtils.isNotEmpty((CharSequence)longPathErrorMessage)) {
                LogUtil.printErrorLine((String)longPathErrorMessage);
            }
            this.stop();
        }
    }

    @Override
    protected void onUpdateResult(TestStatus.TestStatusValue testStatusValue) {
        super.onUpdateResult(testStatusValue);
    }

    protected synchronized void writeLine(String line) {
        try {
            IOutputStream os = this.process.getOutputStreamHandler();
            if (os != null) {
                os.println(line);
            }
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
    }

    protected synchronized void writeError(String line) {
        try {
            IOutputStream es = this.process.getErrorStreamHandler();
            if (es != null) {
                es.println(line);
            }
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
    }

    protected abstract ILaunchProcess launch() throws ExecutionException;

    protected void onStartExecution() {
    }

    protected void onStartExecutionComplete() {
    }

    @Override
    public void stop() {
        this.setStatus(LauncherStatus.TERMINATED);
        if (this.watchdog != null) {
            this.watchdog.stop();
        }
    }

    protected void setRunConfig(IRunConfiguration runConfig) {
        this.runConfig = runConfig;
        this.executedEntity = runConfig.getExecutionSetting().getExecutedEntity();
        this.result = new LauncherResult(this.executedEntity.getTotalTestCases());
    }

    @Override
    public final void onWatchdogComplete(LaunchWatchdog watchdog) {
        if (this.watchdog != watchdog) {
            return;
        }
        LogUtil.logInfo((String)("Launcher status after execution process completed: " + String.valueOf((Object)this.getStatus())));
        if (this.getStatus() != LauncherStatus.TERMINATED) {
            if (this.parentLauncher != null) {
                this.preExecutionComplete(false);
            } else {
                this.preExecutionComplete(true);
            }
            this.setStatus(LauncherStatus.DONE);
        } else {
            this.setStatus(LauncherStatus.TERMINATED);
        }
        this.schedule();
        this.postExecutionComplete();
    }

    protected void postExecutionComplete() {
        try {
            if (this.process == null) {
                return;
            }
            if (this.process.getOutputStreamHandler() != null) {
                this.process.getOutputStreamHandler().close();
            }
            if (this.process.getErrorStreamHandler() != null) {
                this.process.getErrorStreamHandler().close();
            }
        }
        catch (IOException iOException) {}
    }

    protected void schedule() {
        try {
            this.manager.stopRunningAndSchedule(this);
        }
        catch (InterruptedException e) {
            LogUtil.logError((Throwable)e);
        }
    }

    protected void preExecutionComplete(boolean runTestSuite) {
    }

    @Override
    public void clean() {
        File scriptFile = this.getRunConfig().getExecutionSetting().getScriptFile();
        FileUtils.deleteQuietly((File)scriptFile);
    }

    public void setParentLauncher(BasicLauncher parentLauncher) {
        this.parentLauncher = parentLauncher;
    }
}

