/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.session;

import com.kms.katalon.core.webui.driver.ExistingRemoteWebDriver;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.RemoteWebDriver;

public class ExecutionSession {
    protected String sessionId;
    protected String remoteUrl;
    protected String driverTypeName;
    protected String logFolderPath;
    protected String title;
    protected String webSocketUrl;
    protected boolean isAlive;
    protected boolean isAvailable;
    protected RemoteWebDriver existingDriver;

    public ExecutionSession(String sessionId, String remoteUrl, String driverTypeName, String logFolderPath, String webSocketUrl) {
        this.sessionId = sessionId;
        this.remoteUrl = remoteUrl;
        this.driverTypeName = driverTypeName;
        this.logFolderPath = logFolderPath;
        this.isAlive = true;
        this.isAvailable = false;
        this.webSocketUrl = webSocketUrl;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getRemoteUrl() {
        return this.remoteUrl;
    }

    public String getDriverTypeName() {
        return this.driverTypeName;
    }

    public String getLogFolderPath() {
        return this.logFolderPath;
    }

    public String getTitle() {
        if (this.title == null) {
            return this.driverTypeName;
        }
        return this.title;
    }

    public String getWebSocketUrl() {
        return this.webSocketUrl;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public void stop() {
        this.isAlive = false;
    }

    public void pause() {
        this.isAvailable = false;
    }

    public void resume() {
        this.isAvailable = true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ExecutionSession)) {
            return false;
        }
        ExecutionSession other = (ExecutionSession)object;
        return new EqualsBuilder().append((Object)this.sessionId, (Object)other.sessionId).append((Object)this.remoteUrl, (Object)other.remoteUrl).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.sessionId).append((Object)this.remoteUrl).toHashCode();
    }

    protected RemoteWebDriver getExistingDriver() throws MalformedURLException, ConnectException {
        if (this.existingDriver == null) {
            this.existingDriver = new ExistingRemoteWebDriver(new URL(this.remoteUrl), this.sessionId, this.webSocketUrl);
        }
        return this.existingDriver;
    }

    protected void checkStatusAndUpdateTitle() throws MalformedURLException, WebDriverException, ConnectException {
        this.title = this.getExistingDriver().getTitle();
    }
}

