/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;

public class ExecutionExceptionUtil {
    public static String getLongPathErrorMessage(Throwable throwable) {
        if (!ExecutionExceptionUtil.isWindowsLongPathException(throwable)) {
            return "";
        }
        String eclipsePath = ExecutionExceptionUtil.getEclipsePath();
        if (StringUtils.isEmpty((CharSequence)eclipsePath)) {
            return "Execution failed: Package path is too long. Please shorten package path to stay within Windows command length limits.";
        }
        String messageFormat = "Execution failed: Package path is too long - %s. Please shorten package path to stay within Windows command length limits.";
        return messageFormat.formatted(eclipsePath);
    }

    public static boolean isWindowsLongPathException(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        String error = sw.toString();
        return error.contains("CreateProcess error=206");
    }

    private static String getEclipsePath() {
        Location installationPath;
        String eclipseHome = System.getProperty("eclipse.home.location");
        if (StringUtils.isNotEmpty((CharSequence)eclipseHome)) {
            if (eclipseHome.startsWith("file:")) {
                eclipseHome = eclipseHome.substring(5);
            }
            eclipseHome = URLDecoder.decode(eclipseHome, StandardCharsets.UTF_8);
        }
        if (StringUtils.isEmpty((CharSequence)eclipseHome) && (installationPath = Platform.getInstallLocation()) != null) {
            eclipseHome = installationPath.getURL().getPath();
        }
        if (StringUtils.isNotEmpty((CharSequence)eclipseHome) && eclipseHome.startsWith("/")) {
            eclipseHome = eclipseHome.substring(1);
        }
        return eclipseHome;
    }
}

