/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.Optional;
import java.util.function.Function;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.jdt.groovy.model.GroovyClassFileWorkingCopy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.MethodDeclarationMatch;
import org.eclipse.jdt.core.search.MethodReferenceMatch;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.MethodReferenceSearchRequestor;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.internal.core.search.matching.ConstructorPattern;
import org.eclipse.jdt.internal.core.util.Util;

public class ConstructorReferenceSearchRequestor
implements ITypeRequestor {
    protected final SearchRequestor requestor;
    protected final SearchParticipant participant;
    protected final String declaringQualifiedName;
    protected final String[] parameterQualifiedNames;
    protected final boolean findDeclarations;
    protected final boolean findReferences;

    public ConstructorReferenceSearchRequestor(ConstructorPattern pattern, SearchRequestor requestor, SearchParticipant participant) {
        this.requestor = requestor;
        this.participant = participant;
        IType declaringType = ((IMethod)pattern.focus).getDeclaringType();
        char[] declaringQualifier = Optional.ofNullable(pattern.declaringQualification).orElse(declaringType.getPackageFragment().getElementName().toCharArray());
        this.declaringQualifiedName = String.valueOf(CharOperation.concat((char[])declaringQualifier, (char[])pattern.declaringSimpleName, (char)'.'));
        this.parameterQualifiedNames = new String[pattern.parameterCount];
        int i = 0;
        while (i < pattern.parameterCount) {
            if (pattern.parameterQualifications[i] != null || MethodReferenceSearchRequestor.isPrimitiveType(pattern.parameterSimpleNames[i])) {
                this.parameterQualifiedNames[i] = String.valueOf(CharOperation.concat((char[])pattern.parameterQualifications[i], (char[])pattern.parameterSimpleNames[i], (char)'.'));
            } else {
                int arrayCount = 0;
                int j = pattern.parameterSimpleNames[i].length - 1;
                while (pattern.parameterSimpleNames[i][j] == ']') {
                    ++arrayCount;
                    j -= 2;
                }
                try {
                    String[][] resolved = declaringType.resolveType(String.valueOf(pattern.parameterSimpleNames[i], 0, j + 1));
                    this.parameterQualifiedNames[i] = Signature.toQualifiedName((String[])resolved[0]);
                    if (this.parameterQualifiedNames[i].charAt(0) == '.') {
                        this.parameterQualifiedNames[i] = this.parameterQualifiedNames[i].substring(1);
                    }
                    while (arrayCount-- > 0) {
                        int n = i;
                        this.parameterQualifiedNames[n] = String.valueOf(this.parameterQualifiedNames[n]) + "[]";
                    }
                }
                catch (Exception e) {
                    Util.log((Throwable)e);
                }
            }
            ++i;
        }
        this.findDeclarations = (Boolean)ReflectionUtils.getPrivateField(ConstructorPattern.class, "findDeclarations", pattern);
        this.findReferences = (Boolean)ReflectionUtils.getPrivateField(ConstructorPattern.class, "findReferences", pattern);
    }

    @Override
    public ITypeRequestor.VisitStatus acceptASTNode(ASTNode node, TypeLookupResult result, IJavaElement enclosingElement) {
        if (node instanceof AnnotatedNode && ((AnnotatedNode)node).getNameEnd() > 0 && result.declaration instanceof ConstructorNode) {
            String typeName;
            if (this.findDeclarations && node instanceof ConstructorNode) {
                ConstructorNode decl = (ConstructorNode)node;
                typeName = result.declaringType.getName().replace('$', '.');
                if (typeName.equals(this.declaringQualifiedName) && this.hasMatchingParameters(decl.getParameters())) {
                    this.reportSearchMatch(enclosingElement, element -> new MethodDeclarationMatch(element, 0, decl.getNameStart(), decl.getNameEnd() + 1 - decl.getNameStart(), this.participant, element.getResource()));
                }
            }
            if (this.findReferences && node instanceof ConstructorCallExpression) {
                ConstructorCallExpression call = (ConstructorCallExpression)node;
                typeName = result.declaringType.getName().replace('$', '.');
                Parameter[] parameters = ((ConstructorNode)result.declaration).getParameters();
                if (typeName.equals(this.declaringQualifiedName) && this.hasMatchingParameters(parameters)) {
                    this.reportSearchMatch(enclosingElement, element -> {
                        boolean isConstructor = true;
                        boolean isSynthetic = false;
                        boolean isSuperInvocation = call.isSuperCall();
                        boolean isWithinComment = false;
                        return new MethodReferenceMatch(element, 0, call.getNameStart(), call.getNameEnd() + 1 - call.getNameStart(), isConstructor, isSynthetic, isSuperInvocation, isWithinComment, this.participant, element.getResource());
                    });
                }
            }
        }
        return ITypeRequestor.VisitStatus.CONTINUE;
    }

    protected void reportSearchMatch(IJavaElement element, Function<IJavaElement, SearchMatch> producer) {
        if (element.getOpenable() instanceof GroovyClassFileWorkingCopy) {
            element = ((GroovyClassFileWorkingCopy)element.getOpenable()).convertToBinary(element);
        }
        SearchMatch match = producer.apply(element);
        try {
            this.requestor.acceptSearchMatch(match);
        }
        catch (CoreException e) {
            Util.log((Throwable)e, (String)("Error reporting search match inside of " + element + " in resource " + element.getResource()));
        }
    }

    protected boolean hasMatchingParameters(Parameter[] declarationParameters) {
        if (declarationParameters.length == this.parameterQualifiedNames.length) {
            int i = 0;
            while (i < this.parameterQualifiedNames.length) {
                ClassNode pattern;
                ClassNode candidate = declarationParameters[i].getType();
                if (!candidate.equals((Object)(pattern = GroovyUtils.makeType(this.parameterQualifiedNames[i])))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

