/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.util;

import com.kms.katalon.util.ExecutorUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;

public class FileUploadManager<ArtifactType> {
    private static final int DEFAULT_MAX_POOL_SIZE = 200;
    private List<ArtifactUploader<ArtifactType>> uploaders = new ArrayList<ArtifactUploader<ArtifactType>>();
    private ExecutorService pool;
    private int maxPoolSize = 200;

    public ExecutorService getPool() {
        if (this.pool == null) {
            this.pool = new ForkJoinPool(this.getMaxPoolSize(), ForkJoinPool.defaultForkJoinWorkerThreadFactory, null, true);
        }
        return this.pool;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize != 0 ? maxPoolSize : 200;
    }

    public void addUploader(ArtifactUploader<ArtifactType> uploader) {
        this.uploaders.add(uploader);
    }

    public void removeUploader(ArtifactUploader<ArtifactType> uploader) {
        this.uploaders.remove(uploader);
    }

    public FileUploadManager(int poolSize) {
        this.setMaxPoolSize(poolSize);
    }

    public FileUploadManager() {
    }

    public void upload(List<ArtifactType> artifacts) {
        ExecutorService pool = this.getPool();
        artifacts.parallelStream().forEach(pathI -> this.upload(pathI, this.uploaders, pool));
    }

    private void upload(ArtifactType artifact, List<ArtifactUploader<ArtifactType>> uploaders, ExecutorService pool) {
        uploaders.parallelStream().forEach(uploaderI -> pool.submit(() -> uploaderI.upload(artifact)));
    }

    public void waitForAllUploads() {
        ExecutorUtils.awaitWithGracefulShutdown(this.pool);
        this.pool = null;
    }

    public static interface ArtifactUploader<ArtifactType> {
        public void upload(ArtifactType var1);
    }
}

