/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.util;

import java.util.concurrent.TimeUnit;

public class RetryController {
    private int maxRetries = 0;
    private long delay = 0L;
    private int currentRetries = 0;
    private Throwable lastError;

    public Throwable getLastError() {
        return this.lastError;
    }

    public void setLastError(Throwable lastError) {
        this.lastError = lastError;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public int getCurrentRetries() {
        return this.currentRetries;
    }

    private void setCurrentRetries(int currentRetries) {
        this.currentRetries = currentRetries;
    }

    public int getRemainingRetries() {
        return Math.max(this.maxRetries - this.currentRetries, 0);
    }

    private void reset() {
        this.setCurrentRetries(0);
        this.setLastError(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(Retryable retryable) {
        try {
            this.reset();
            while (true) {
                if (retryable.execute(this.currentRetries)) {
                    return true;
                }
                if (this.getRemainingRetries() == 0) {
                    return false;
                }
                ++this.currentRetries;
                TimeUnit.SECONDS.sleep(this.delay);
            }
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    public static interface Retryable {
        public boolean execute(int var1);
    }
}

