/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.util;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.core.Signature;

public class TypeUtil {
    private static Map<String, String> primitivesToWrappers = new HashMap<String, String>(){
        {
            this.put(Boolean.TYPE.getName(), Boolean.class.getName());
            this.put(Character.TYPE.getName(), Character.class.getName());
            this.put(Byte.TYPE.getName(), Byte.class.getName());
            this.put(Short.TYPE.getName(), Short.class.getName());
            this.put(Integer.TYPE.getName(), Integer.class.getName());
            this.put(Long.TYPE.getName(), Long.class.getName());
            this.put(Float.TYPE.getName(), Float.class.getName());
            this.put(Double.TYPE.getName(), Double.class.getName());
            this.put(Void.TYPE.getName(), Void.class.getName());
        }
    };

    public static boolean primitiveAwareSameTypeCheck(String first, String second) {
        if (first.equals(second)) {
            return true;
        }
        if (primitivesToWrappers.containsKey(first) && primitivesToWrappers.get(first).equals(second)) {
            return true;
        }
        return primitivesToWrappers.containsKey(second) && primitivesToWrappers.get(second).equals(first);
    }

    public static boolean primitiveAwareSameTypesCheck(String[] first, String[] second) {
        if (first.length != second.length) {
            return false;
        }
        int i = 0;
        while (i < first.length) {
            if (!TypeUtil.primitiveAwareSameTypeCheck(first[i], second[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean primitiveAwareSameTypesCheckWithLooseTypeMatching(String[] first, String[] second) {
        if (first.length != second.length) {
            return false;
        }
        int i = 0;
        while (i < first.length) {
            boolean matchType;
            boolean bl = matchType = TypeUtil.primitiveAwareSameTypeCheck(first[i], second[i]) || first[i].endsWith(second[i]) || second[i].endsWith(first[i]);
            if (!matchType) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String[] toReadableTypes(String[] types) {
        String[] readableTypes = Stream.of(types).map(t -> {
            try {
                return Signature.toString((String)t);
            }
            catch (Exception exception) {
                return t;
            }
        }).collect(Collectors.toList()).toArray(new String[types.length]);
        return readableTypes;
    }

    public static boolean isPrimitive(String type) {
        return primitivesToWrappers.containsKey(type);
    }

    public static String getWrapper(String primitiveType) {
        return primitivesToWrappers.get(primitiveType);
    }
}

