/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.testops.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.kms.katalon.composer.testops.service.AnalyticsSettingStore;
import com.kms.katalon.discovery.core.model.ServerType;
import com.kms.katalon.discovery.core.model.exception.DiscoveryException;
import com.kms.katalon.discovery.core.services.IDiscoveryManager;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.network.core.model.exception.HttpException;
import com.kms.katalon.network.core.model.exception.MalformedContentException;
import com.kms.katalon.network.core.model.exception.NetworkErrorException;
import com.kms.katalon.network.core.model.exception.UrlInvalidException;
import com.kms.katalon.network.core.services.IDownloadProgress;
import com.kms.katalon.session.core.model.AdminJwtToken;
import com.kms.katalon.session.core.model.AdministrationManagedKsSetting;
import com.kms.katalon.session.core.model.AiConfigPolicy;
import com.kms.katalon.session.core.model.AuthenticationToken;
import com.kms.katalon.session.core.model.Organization;
import com.kms.katalon.session.core.model.OrganizationSetting;
import com.kms.katalon.session.core.model.Project;
import com.kms.katalon.session.core.model.Session;
import com.kms.katalon.session.core.model.UserInfo;
import com.kms.katalon.session.core.model.exception.AuthenticationException;
import com.kms.katalon.session.core.model.exception.SessionException;
import com.kms.katalon.session.core.services.IAdminService;
import com.kms.katalon.session.core.services.ISessionManager;
import com.kms.katalon.testops.core.model.AnalyticsAuthenticationSetting;
import com.kms.katalon.testops.core.model.AnalyticsExecution;
import com.kms.katalon.testops.core.model.AnalyticsFileInfo;
import com.kms.katalon.testops.core.model.AnalyticsIntegrationSetting;
import com.kms.katalon.testops.core.model.AnalyticsPlan;
import com.kms.katalon.testops.core.model.AnalyticsProject;
import com.kms.katalon.testops.core.model.AnalyticsRelease;
import com.kms.katalon.testops.core.model.AnalyticsSetting;
import com.kms.katalon.testops.core.model.AnalyticsTestCase;
import com.kms.katalon.testops.core.model.AnalyticsTestRun;
import com.kms.katalon.testops.core.model.AnalyticsTracking;
import com.kms.katalon.testops.core.model.AnalyticsUploadInfo;
import com.kms.katalon.testops.core.model.ExecutionReportScanResult;
import com.kms.katalon.testops.core.model.TestOpsLoadOptions;
import com.kms.katalon.testops.core.model.TestOpsProjectStatistics;
import com.kms.katalon.testops.core.model.TestOpsRequestOptions;
import com.kms.katalon.testops.core.model.TestOpsSession;
import com.kms.katalon.testops.core.model.TestOpsTotalExecutionStatistics;
import com.kms.katalon.testops.core.model.exception.AnalyticsApiException;
import com.kms.katalon.testops.core.model.exception.TestOpsException;
import com.kms.katalon.testops.core.services.ITestOpsManager;
import com.kms.katalon.testops.core.services.ITestOpsPreferences;
import com.kms.katalon.testops.core.services.ITestOpsService;
import com.kms.katalon.util.FileUploadManager;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.File;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
@Singleton
public class TestOpsManager
implements ITestOpsManager {
    private static final int TOKEN_BUFFER_SECONDS = 300;
    public static final String REPORT_UPLOAD_POOL_SIZE_PROP = "reportUploadPoolSize";
    @Inject
    private IAdminService adminService;
    @Inject
    private IDiscoveryManager discoveryManager;
    @Inject
    private ISessionManager sessionManager;
    @Inject
    private ITestOpsService testOpsService;
    @Inject
    private ITestOpsPreferences preferences;
    private final Logger logger = LoggerFactory.getLogger(TestOpsManager.class);
    private TestOpsSession session;
    private AnalyticsIntegrationSetting integrationSetting;
    private ScheduledFuture<?> checkingTokenTask;
    private Boolean overrideTestOpsEnabled = null;

    public AnalyticsSetting getSetting() throws TestOpsException {
        return this.preferences.getSetting();
    }

    public void saveSetting(AnalyticsSetting setting) throws TestOpsException {
        this.preferences.saveSetting(setting);
    }

    public boolean canOverrideSession() {
        Organization organization = this.sessionManager.getOrganization();
        return organization == null || !organization.isSamlSSO();
    }

    public boolean isIntegrated() {
        if (this.overrideTestOpsEnabled != null) {
            return this.overrideTestOpsEnabled;
        }
        if (this.integrationSetting == null) {
            return false;
        }
        if (this.session != null) {
            return true;
        }
        AuthenticationToken loginSession = this.sessionManager.getAdminToken();
        return loginSession != null;
    }

    public boolean isAutoUploadReportEnabled() {
        return this.isIntegrated() && this.integrationSetting.isAutoUploadReports();
    }

    public TestOpsSession authenticate(AnalyticsAuthenticationSetting setting) throws TestOpsException {
        AuthenticationToken katOneToken;
        UserInfo userInfo;
        AuthenticationToken adminToken;
        String serverUrl = setting.getServerUrl();
        Map serverInfo = Map.of();
        try {
            serverInfo = this.discoveryManager.getServerInfo(serverUrl);
        }
        catch (DiscoveryException e) {
            this.logger.error(e.getMessage());
        }
        String adminServerUrl = (String)StringUtils.defaultIfBlank((CharSequence)((String)serverInfo.get(ServerType.ADMIN)), (CharSequence)serverUrl);
        String testOpsServerUrl = (String)StringUtils.defaultIfBlank((CharSequence)((String)serverInfo.get(ServerType.TESTOPS)), (CharSequence)serverUrl);
        try {
            adminToken = this.adminService.getAdminToken(adminServerUrl, setting.getEmail(), setting.getPassword());
            userInfo = this.adminService.getUserInfo(adminServerUrl, adminToken);
            AdminJwtToken jwtToken = AdminJwtToken.parseToken((String)adminToken.getAccessToken());
            String katOneJwt = jwtToken.getKatOneJwt();
            katOneToken = StringUtils.isNotBlank((CharSequence)katOneJwt) ? new AuthenticationToken(katOneJwt, null) : adminToken;
        }
        catch (MalformedContentException | NetworkErrorException | UrlInvalidException | AuthenticationException | URISyntaxException e) {
            throw new TestOpsException(e);
        }
        TestOpsSession session = new TestOpsSession();
        session.setEmail(setting.getEmail());
        session.setPassword(setting.getPassword());
        session.setToken(adminToken);
        session.setKatOneToken(katOneToken);
        session.setUserInfo(userInfo);
        if (serverInfo.isEmpty()) {
            serverInfo = userInfo.getConfigs().getServerInfo();
        }
        session.setServerUrl(testOpsServerUrl);
        session.setServerInfo(serverInfo);
        return session;
    }

    public void useSession(TestOpsSession session, AnalyticsIntegrationSetting integrationSetting) throws TestOpsException {
        if (!this.canOverrideSession() && session != null) {
            throw new TestOpsException("TestOps: Cannot override authentication!");
        }
        this.session = session;
        this.integrationSetting = integrationSetting;
        this.startStartRefreshTokenTask();
    }

    public void reload(TestOpsLoadOptions loadOptions) throws TestOpsException {
        UserInfo userInfo;
        Boolean overrideTestOpsEnabled;
        this.useSession(null, null);
        this.overrideTestOpsEnabled = overrideTestOpsEnabled = loadOptions != null ? loadOptions.getOverrideTestOpsEnabled() : null;
        Boolean overrideAuthentication = loadOptions != null ? loadOptions.getOverrideAuthentication() : null;
        String serverUrl = loadOptions != null ? loadOptions.getServerUrl() : null;
        Long projectId = loadOptions != null ? loadOptions.getProjectId() : null;
        AnalyticsSetting setting = this.preferences.getSetting();
        AnalyticsAuthenticationSetting authSetting = setting.getAuthentication();
        if (StringUtils.isNotBlank((CharSequence)serverUrl)) {
            if (authSetting != null) {
                authSetting.setServerUrl(serverUrl);
            } else {
                this.discoveryManager.setServerUrl(ServerType.TESTOPS, serverUrl);
            }
        }
        TestOpsSession session = null;
        if ((overrideAuthentication == null || overrideAuthentication.booleanValue()) && authSetting != null) {
            session = this.authenticate(authSetting);
            Organization organization = authSetting.getOrganization();
            Organization memberOrg = session.getUserInfo().getOrganizations().stream().filter(o -> o.getId().compareTo(organization.getId()) == 0).findAny().orElse(null);
            if (memberOrg == null) {
                throw new TestOpsException("TestOps: Organization is not found!");
            }
            session.setOrganization(memberOrg);
        }
        UserInfo userInfo2 = userInfo = session != null ? session.getUserInfo() : this.sessionManager.getUserInfo();
        if (userInfo == null) {
            throw new TestOpsException("TestOps: No session available!");
        }
        AnalyticsIntegrationSetting integrationSetting = setting.getIntegration();
        if (projectId != null) {
            if (integrationSetting == null) {
                integrationSetting = new AnalyticsIntegrationSetting();
            }
            integrationSetting.setAutoUploadReports(true);
        }
        if (integrationSetting == null) {
            this.useSession(session, null);
            return;
        }
        if (projectId == null) {
            projectId = integrationSetting.getProject().getId();
        }
        if (overrideTestOpsEnabled != null && overrideTestOpsEnabled.booleanValue() && projectId != null) {
            integrationSetting.setAutoUploadReports(true);
        }
        Long finalProjectId = projectId;
        Project memberProject = userInfo.getProjects().stream().filter(p -> p.getId().equals(finalProjectId)).findAny().orElse(null);
        if (memberProject == null) {
            throw new TestOpsException("TestOps: Does not have access to project with ID " + String.valueOf(projectId));
        }
        integrationSetting.setProject(memberProject);
        this.useSession(session, integrationSetting);
    }

    public void refreshToken() throws TestOpsException {
        if (this.session == null) {
            try {
                this.sessionManager.renewTokens();
            }
            catch (SessionException e) {
                this.logger.error(e.getMessage());
                throw new TestOpsException((Throwable)e);
            }
        }
        try {
            String adminServerUrl = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.session.getServerInfo().get(ServerType.ADMIN)), (CharSequence)this.session.getServerUrl());
            AuthenticationToken newToken = this.adminService.getAdminToken(adminServerUrl, this.session.getEmail(), this.session.getPassword());
            this.session.setToken(newToken);
        }
        catch (MalformedContentException | NetworkErrorException | UrlInvalidException | AuthenticationException | URISyntaxException e) {
            this.logger.error(e.getMessage());
            throw new TestOpsException(e);
        }
    }

    public TestOpsRequestOptions getRequestOptions() {
        return TestOpsRequestOptions.builder().serverUrl(this.getServerUrl(ServerType.TESTOPS)).session(this.getSession()).integratedSetting(this.integrationSetting).build();
    }

    public TestOpsRequestOptions getRequestOptions(boolean ignoreOverriding) {
        return TestOpsRequestOptions.builder().serverUrl(this.getServerUrl(ServerType.TESTOPS, ignoreOverriding)).session(this.getSession(ignoreOverriding)).integratedSetting(this.integrationSetting).build();
    }

    public AuthenticationToken getKatOneToken() {
        return this.session != null ? this.session.getKatOneToken() : this.sessionManager.getKatOneToken();
    }

    @Deprecated
    public Long getAccountId() {
        Organization organization = this.session != null ? this.session.getOrganization() : this.sessionManager.getOrganization();
        return organization != null ? organization.getAccountId() : null;
    }

    public Long getAccountIdOfActiveProject() {
        Project project = this.getProject();
        if (project == null) {
            return null;
        }
        return project.getAccountId();
    }

    @Deprecated
    public Organization getOrganization() {
        return this.session != null ? this.session.getOrganization() : this.sessionManager.getOrganization();
    }

    public Project getProject() {
        return this.integrationSetting != null ? this.integrationSetting.getProject() : null;
    }

    public Long getOrganizationIdOfActiveProject() {
        Project project = this.getProject();
        if (project == null) {
            return null;
        }
        return project.getOrganizationId();
    }

    public Long getProjectId() {
        Project project = this.getProject();
        if (project == null) {
            return null;
        }
        return project.getId();
    }

    public List<Organization> getKreOrganizations() throws AnalyticsApiException {
        List organizations;
        String serverUrl = this.getServerUrl(ServerType.ADMIN);
        TestOpsRequestOptions requestOptions = this.getRequestOptions();
        try {
            organizations = this.adminService.getOrganizations(serverUrl, requestOptions.getSession().getToken());
        }
        catch (MalformedContentException | NetworkErrorException | AuthenticationException | URISyntaxException e) {
            throw new AnalyticsApiException(e);
        }
        return organizations.stream().filter(Organization::hasKreLicense).filter(org -> !org.isSamlSSO() || !org.isStrictDomain()).toList();
    }

    public File downloadReport(Long executionId, IDownloadProgress progress) throws AnalyticsApiException {
        return this.testOpsService.downloadReport(executionId, progress, this.getRequestOptions());
    }

    public String fetchAPIKey(TestOpsRequestOptions options) throws AnalyticsApiException {
        return this.testOpsService.fetchAPIKey(options);
    }

    public List<AnalyticsExecution> getCompletedExecutions(Long projectId, int size) throws AnalyticsApiException {
        return this.testOpsService.getCompletedExecutions(projectId, size, this.getRequestOptions());
    }

    public List<AnalyticsExecution> getCompletedExecutionTestSuite(Long projectId, String testSuitePath, String testSuiteName, int size) throws AnalyticsApiException {
        return this.testOpsService.getCompletedExecutionTestSuite(projectId, testSuitePath, testSuiteName, size, this.getRequestOptions());
    }

    public List<AnalyticsExecution> getExecutions(Long projectId) throws AnalyticsApiException {
        return this.testOpsService.getExecutions(projectId, this.getRequestOptions());
    }

    public List<AnalyticsRelease> getFirstReleasesPage(Long projectId) throws AnalyticsApiException {
        return this.testOpsService.getFirstReleasesPage(projectId, this.getRequestOptions());
    }

    public List<AnalyticsUploadInfo> getMultipleUploadInfo(Long projectId, Long numberUploadInfo) throws AnalyticsApiException {
        return this.testOpsService.getMultipleUploadInfo(projectId, numberUploadInfo, this.getRequestOptions());
    }

    public OrganizationSetting getOrganizationSetting() throws TestOpsException {
        Long organizationId = this.getOrganizationIdOfActiveProject();
        if (organizationId == null) {
            throw new TestOpsException();
        }
        return this.getOrganizationSetting(organizationId, this.getRequestOptions());
    }

    public OrganizationSetting getOrganizationSetting(Long orgId, TestOpsRequestOptions options) throws TestOpsException {
        try {
            return this.testOpsService.getOrganizationSetting(orgId, options);
        }
        catch (HttpException | TestOpsException | URISyntaxException e) {
            throw new TestOpsException(e);
        }
    }

    public List<AnalyticsPlan> getPlans(Long projectId) throws AnalyticsApiException {
        return this.testOpsService.getPlans(projectId, this.getRequestOptions());
    }

    public List<AnalyticsProject> getProjects() throws AnalyticsApiException {
        Organization organization = this.getOrganization();
        List projects = this.testOpsService.getProjects(this.getRequestOptions());
        return projects.stream().filter(p -> Objects.equals(p.getAccountId(), organization.getAccountId())).toList();
    }

    public TestOpsProjectStatistics getProjectStatisticsInLast7Days(Long projectId) throws AnalyticsApiException {
        return this.testOpsService.getProjectStatisticsInLast7Days(projectId, this.getRequestOptions());
    }

    public List<AnalyticsRelease> getReleases(Long projectId) throws AnalyticsApiException {
        return this.testOpsService.getReleases(projectId, this.getRequestOptions());
    }

    public List<AnalyticsTestCase> getTestCaseRuns(Long projectId, List<String> testCaseIds) throws AnalyticsApiException {
        return this.testOpsService.getTestCaseRuns(projectId, testCaseIds, this.getRequestOptions());
    }

    public String getTestCloudServerUrl() {
        return this.getServerUrl(ServerType.TESTCLOUD);
    }

    public TestOpsTotalExecutionStatistics getTotalExecutionsStatistics(Long projectId) throws AnalyticsApiException {
        return this.testOpsService.getTotalExecutionsStatistics(projectId, this.getRequestOptions());
    }

    public boolean isTestCloudIntegrationEnabled() {
        AnalyticsSettingStore settingStore = AnalyticsSettingStore.getStore();
        if (settingStore == null) {
            return false;
        }
        return this.isIntegrated() && settingStore.isTestCloudIntegrationEnabled();
    }

    public List<AnalyticsExecution> sendLog(Long projectId, Long timestamp, String folderName, File file, boolean isEnd) throws AnalyticsApiException {
        return this.testOpsService.sendLog(projectId, timestamp, folderName, file, isEnd, this.getRequestOptions());
    }

    public void sendTrackingActivity(AnalyticsTracking trackingInfo) throws AnalyticsApiException {
        this.testOpsService.sendTrackingActivity(trackingInfo, this.getRequestOptions());
    }

    public void updateTestRunResult(Long projectId, AnalyticsTestRun testRun) throws AnalyticsApiException {
        this.testOpsService.updateTestRunResult(projectId, testRun, this.getRequestOptions());
    }

    public List<AnalyticsExecution> uploadExecutionReports(ExecutionReportScanResult reportScanResult, Path reportsFolder, Long projectId, Long batchId) throws AnalyticsApiException {
        AnalyticsFileInfo lastFile;
        long numFiles = reportScanResult.getAll().size();
        List<AnalyticsUploadInfo> uploadInfoList = this.getMultipleUploadInfo(projectId, numFiles);
        ArrayList fileInfoList = new ArrayList();
        LogUtil.printOutputLine((String)MessageFormat.format("TestOps: Will upload {0} file(s)", numFiles));
        String rawCustomPoolSize = System.getProperty(REPORT_UPLOAD_POOL_SIZE_PROP);
        int poolSize = rawCustomPoolSize != null ? Integer.parseInt(rawCustomPoolSize) : 0;
        FileUploadManager uploadManager = new FileUploadManager(poolSize);
        uploadManager.addUploader(artifact -> {
            Path filePath = artifact.get();
            if (filePath == null) {
                return;
            }
            LogUtil.printOutputLine((String)MessageFormat.format("TestOps: Uploading file \"{0}\"", filePath.toAbsolutePath()));
            String relativePath = reportsFolder.relativize(filePath.getParent()).toString();
            AnalyticsUploadInfo uploadInfo = null;
            List list3 = uploadInfoList;
            synchronized (list3) {
                uploadInfo = (AnalyticsUploadInfo)uploadInfoList.remove(uploadInfoList.size() - 1);
            }
            File file = filePath.toFile();
            try {
                this.testOpsService.uploadFileWithRetry(uploadInfo.getUploadUrl(), file);
            }
            catch (AnalyticsApiException analyticsApiException) {
                return;
            }
            AnalyticsFileInfo fileInfo = new AnalyticsFileInfo();
            fileInfo.setFolderPath(relativePath);
            fileInfo.setFileName(file.getName());
            fileInfo.setUploadedPath(uploadInfo.getPath());
            List list4 = fileInfoList;
            synchronized (list4) {
                fileInfoList.add(fileInfo);
            }
            LogUtil.printOutputLine((String)MessageFormat.format("TestOps: Done uploading file \"{0}\"", filePath.toAbsolutePath()));
        });
        uploadManager.upload(reportScanResult.getFutureArtifacts());
        uploadManager.upload(reportScanResult.getNormalArtifacts());
        uploadManager.waitForAllUploads();
        if (fileInfoList.size() > 0 && (lastFile = (AnalyticsFileInfo)fileInfoList.get(fileInfoList.size() - 1)) != null) {
            lastFile.setEnd(true);
        }
        LogUtil.printOutputLine((String)MessageFormat.format("TestOps: Will send upload summary result of {0} file(s)", fileInfoList.size()));
        return this.testOpsService.uploadMultipleFileInfo(projectId, batchId, fileInfoList, this.getRequestOptions());
    }

    public boolean isOnline() {
        return this.discoveryManager.isOnline(this.getServerUrl(ServerType.TESTOPS));
    }

    private void startStartRefreshTokenTask() {
        this.endRefreshTokenTask();
        if (this.session == null) {
            return;
        }
        LogUtil.logInfo((String)"Start refresh TestOps token task");
        this.checkingTokenTask = Executors.newScheduledThreadPool(1).scheduleAtFixedRate(() -> {
            if (this.session == null) {
                this.endRefreshTokenTask();
                return;
            }
            AdminJwtToken accessToken = AdminJwtToken.parseToken((String)this.session.getToken().getAccessToken());
            long currentEpoch = Instant.now().getEpochSecond();
            if (accessToken.getExp() >= currentEpoch + 300L) {
                return;
            }
            try {
                this.refreshToken();
            }
            catch (TestOpsException e) {
                this.logger.error(e.getMessage());
            }
        }, 0L, 30L, TimeUnit.SECONDS);
    }

    private void endRefreshTokenTask() {
        if (this.checkingTokenTask != null) {
            LogUtil.logInfo((String)"End refresh TestOps token task");
            this.checkingTokenTask.cancel(true);
            this.checkingTokenTask = null;
        }
    }

    private TestOpsSession getSession() {
        if (this.session != null) {
            return this.session;
        }
        return this.getSession(true);
    }

    private TestOpsSession getSession(boolean ignoreOverriding) {
        if (!ignoreOverriding) {
            return this.session;
        }
        Session loginSession = this.sessionManager.getSession();
        TestOpsSession session = new TestOpsSession();
        session.setServerUrl(this.discoveryManager.getServerUrl(ServerType.TESTOPS));
        session.setOrganization(loginSession.getOrganization());
        session.setToken(loginSession.getAdminToken());
        session.setKatOneToken(loginSession.getKatOneToken());
        session.setUserInfo(loginSession.getUserInfo());
        return session;
    }

    private String getServerUrl(ServerType serverType) {
        String sessionUrl;
        if (serverType == ServerType.TESTOPS && this.session != null) {
            return this.session.getServerUrl();
        }
        String url = this.discoveryManager.getServerUrl(serverType);
        if (this.session != null && StringUtils.isNotBlank((CharSequence)(sessionUrl = (String)this.session.getServerInfo().get(serverType)))) {
            url = sessionUrl;
        }
        return url;
    }

    private String getServerUrl(ServerType serverType, boolean ignoreOverriding) {
        if (ignoreOverriding) {
            return this.discoveryManager.getServerUrl(serverType);
        }
        if (serverType == ServerType.TESTOPS && this.session != null) {
            return this.session.getServerUrl();
        }
        return this.session != null ? (String)this.session.getServerInfo().get(serverType) : null;
    }

    public AdministrationManagedKsSetting getKsAppSetting() throws URISyntaxException, NetworkErrorException, JsonMappingException, JsonProcessingException, MalformedContentException {
        return this.testOpsService.getKsAppSetting();
    }

    public AiConfigPolicy getAiAppConfig(AdministrationManagedKsSetting setting) throws JsonMappingException, JsonProcessingException, URISyntaxException, NetworkErrorException, MalformedContentException {
        return this.testOpsService.getAiAppConfig(setting);
    }
}

