/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.capability.constant;

import com.katalon.capability.constant.DriverPlatform;
import java.util.List;
import java.util.stream.Stream;

public enum DriverType {
    CHROME_DRIVER(DriverPlatform.WEB, "Chrome"),
    FIREFOX_DRIVER(DriverPlatform.WEB, "Firefox"),
    EDGE_CHROMIUM_DRIVER(DriverPlatform.WEB, "Edge Chromium"),
    SAFARI_DRIVER(DriverPlatform.WEB, "Safari"),
    HEADLESS_DRIVER(DriverPlatform.WEB, "Chrome (headless)"),
    FIREFOX_HEADLESS_DRIVER(DriverPlatform.WEB, "Firefox (headless)"),
    REMOTE_WEB_DRIVER(null, "Remote"),
    ANDROID_DRIVER(DriverPlatform.MOBILE, "Android"),
    IOS_DRIVER(DriverPlatform.MOBILE, "iOS"),
    WINDOWS_DRIVER(DriverPlatform.DESKTOP, "Windows"),
    KOBITON_WEB_DRIVER(null, "Kobiton Device"),
    TESTCLOUD_DRIVER(null, "TestCloud");

    private final DriverPlatform driverPlatform;
    private final String displayName;

    private DriverType(DriverPlatform driverPlatform, String displayName) {
        this.driverPlatform = driverPlatform;
        this.displayName = displayName;
    }

    public DriverPlatform getDriverPlatform() {
        return this.driverPlatform;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static DriverType fromDisplayName(String displayName) {
        DriverType[] driverTypeArray = DriverType.values();
        int n = driverTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DriverType driverType = driverTypeArray[n2];
            if (driverType.getDisplayName().equalsIgnoreCase(displayName)) {
                return driverType;
            }
            ++n2;
        }
        return null;
    }

    public static List<DriverType> getDriverTypesByPlatform(DriverPlatform platform) {
        return Stream.of(DriverType.values()).filter(driverType -> driverType.getDriverPlatform() == platform).toList();
    }
}

