/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.capability.constant;

import java.util.stream.Stream;

public enum RemoteDriverType {
    SELENIUM("Selenium"),
    APPIUM("Appium");

    private String displayName;

    private RemoteDriverType(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static String[] getDisplayNameArray() {
        return (String[])Stream.of(RemoteDriverType.values()).map(RemoteDriverType::getDisplayName).toArray(String[]::new);
    }

    public static RemoteDriverType fromDisplayName(String displayName) {
        return Stream.of(RemoteDriverType.values()).filter(type -> type.getDisplayName().equals(displayName)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown RemoteDriverType: %s".formatted(displayName)));
    }
}

