/*
 * Decompiled with CFR 0.152.
 */
package org.qas.api;

import java.io.IOException;
import org.qas.api.AuthClientException;

public class AuthServiceException
extends AuthClientException {
    private static final long serialVersionUID = -417899261734955807L;
    private String errorCode;
    private ErrorType errorType = ErrorType.Unknown;
    private int statusCode;
    private String serviceName;
    private String requestId;

    public AuthServiceException(String message) {
        super(message);
    }

    public AuthServiceException(String message, Throwable cause) {
        super(message, cause);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public AuthServiceException withServiceName(String serviceName) {
        this.setServiceName(serviceName);
        return this;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public AuthServiceException withErrorCode(String errorCode) {
        this.setErrorCode(errorCode);
        return this;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public AuthServiceException withStatusCode(int statusCode) {
        this.setStatusCode(statusCode);
        return this;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public void setErrorType(ErrorType errorType) {
        this.errorType = errorType;
    }

    public AuthServiceException withErrorType(ErrorType errorType) {
        this.errorType = errorType;
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public AuthServiceException withRequestId(String requestId) {
        this.setRequestId(requestId);
        return this;
    }

    @Override
    protected void appendExceptionTo(Appendable out, Throwable e) throws IOException {
        out.append(">>> Type: ").append(e.getClass().getName()).append(NL);
        out.append(">>> Message: ").append(e.getMessage()).append(NL);
        out.append(">>> Request Id: ").append(this.getRequestId()).append(NL);
        out.append(">>> Status Code: ").append(String.valueOf(this.getStatusCode())).append(NL);
        out.append(">>> Error Code: ").append(this.getErrorCode()).append(NL);
        out.append(">>> Error Type: ").append(this.getErrorType().name()).append(NL);
    }

    public static enum ErrorType {
        Client,
        Service,
        Unknown;

    }
}

