/*
 * Decompiled with CFR 0.152.
 */
package org.qas.api.http.basic;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Map;
import org.qas.api.Request;
import org.qas.api.http.AbstractHttpRequest;
import org.qas.api.http.HttpMethod;
import org.qas.api.http.HttpRequest;
import org.qas.api.internal.util.google.base.Preconditions;

public final class HttpUrlConnectionRequest
extends AbstractHttpRequest<HttpURLConnection>
implements HttpRequest<HttpURLConnection> {
    private final HttpURLConnection connection;

    public HttpUrlConnectionRequest(Request request, HttpURLConnection connection) {
        super(request);
        Preconditions.checkNotNull(connection);
        this.connection = connection;
    }

    @Override
    public HttpURLConnection getUnderlying() {
        return this.connection;
    }

    public HttpUrlConnectionRequest withHttpMethod(HttpMethod httpMethod) {
        this.setHttpMethod(httpMethod);
        return this;
    }

    public HttpUrlConnectionRequest withContent(InputStream content) {
        this.setContent(content);
        return this;
    }

    @Override
    public int getContentLength() {
        try {
            return Integer.valueOf(this.connection.getRequestProperty("Content-Length"));
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public HttpUrlConnectionRequest withTimeOffset(int timeOffset) {
        this.setTimeOffset(timeOffset);
        return this;
    }

    @Override
    public String getContentType() {
        return this.connection.getContentType();
    }

    public HttpUrlConnectionRequest withResourcePath(String resourcePath) {
        this.setResourcePath(resourcePath);
        return this;
    }

    public HttpUrlConnectionRequest withHeader(String name, String value) {
        this.setHeader(name, value);
        return this;
    }

    public HttpUrlConnectionRequest withHeaders(Map<String, String> headers) {
        this.setHeaders(headers);
        return this;
    }

    public HttpUrlConnectionRequest withParameter(String name, String value) {
        this.addParameter(name, value);
        return this;
    }

    public HttpUrlConnectionRequest withParameters(Map<String, String> parameters) {
        this.setParameters(parameters);
        return this;
    }
}

