/*
 * Decompiled with CFR 0.152.
 */
package org.qas.api.internal.util.json;

import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.Date;
import org.qas.api.internal.util.Encoders;
import org.qas.api.internal.util.json.JsonException;
import org.qas.api.internal.util.json.JsonObject;

public class JsonWriter {
    private static final int MAX_DEPTH = 20;
    private boolean comma = false;
    protected char mode = (char)105;
    private JsonObject[] stack = new JsonObject[20];
    private int top = 0;
    protected Writer writer;

    public JsonWriter(Writer w) {
        this.writer = w;
    }

    private JsonWriter append(String s) throws JsonException {
        if (s == null) {
            throw new JsonException("Null pointer");
        }
        if (this.mode == 'o' || this.mode == 'a') {
            try {
                if (this.comma && this.mode == 'a') {
                    this.writer.write(44);
                }
                this.writer.write(s);
            }
            catch (IOException e) {
                throw new JsonException(e);
            }
            if (this.mode == 'o') {
                this.mode = (char)107;
            }
            this.comma = true;
            return this;
        }
        throw new JsonException("Value out of sequence.");
    }

    public JsonWriter array() throws JsonException {
        if (this.mode == 'i' || this.mode == 'o' || this.mode == 'a') {
            this.push(null);
            this.append("[");
            this.comma = false;
            return this;
        }
        throw new JsonException("Misplaced array.");
    }

    private JsonWriter end(char m, char c) throws JsonException {
        if (this.mode != m) {
            throw new JsonException(m == 'a' ? "Misplaced endArray." : "Misplaced endObject.");
        }
        this.pop(m);
        try {
            this.writer.write(c);
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
        this.comma = true;
        return this;
    }

    public JsonWriter endArray() throws JsonException {
        return this.end('a', ']');
    }

    public JsonWriter endObject() throws JsonException {
        return this.end('k', '}');
    }

    public JsonWriter key(String s) throws JsonException {
        if (s == null) {
            throw new JsonException("Null key.");
        }
        if (this.mode == 'k') {
            try {
                this.stack[this.top - 1].putOnce(s, Boolean.TRUE);
                if (this.comma) {
                    this.writer.write(44);
                }
                this.writer.write(JsonObject.quote(s));
                this.writer.write(58);
                this.comma = false;
                this.mode = (char)111;
                return this;
            }
            catch (IOException e) {
                throw new JsonException(e);
            }
        }
        throw new JsonException("Misplaced key.");
    }

    public JsonWriter object() throws JsonException {
        if (this.mode == 'i') {
            this.mode = (char)111;
        }
        if (this.mode == 'o' || this.mode == 'a') {
            this.append("{");
            this.push(new JsonObject());
            this.comma = false;
            return this;
        }
        throw new JsonException("Misplaced object.");
    }

    private void pop(char c) throws JsonException {
        char m;
        if (this.top <= 0) {
            throw new JsonException("Nesting error.");
        }
        char c2 = m = this.stack[this.top - 1] == null ? (char)'a' : 'k';
        if (m != c) {
            throw new JsonException("Nesting error.");
        }
        --this.top;
        this.mode = (char)(this.top == 0 ? 100 : (this.stack[this.top - 1] == null ? 97 : 107));
    }

    private void push(JsonObject jo) throws JsonException {
        if (this.top >= 20) {
            throw new JsonException("Nesting too deep.");
        }
        this.stack[this.top] = jo;
        this.mode = (char)(jo == null ? 97 : 107);
        ++this.top;
    }

    public JsonWriter value(boolean b) throws JsonException {
        return this.append(b ? "true" : "false");
    }

    public JsonWriter value(double d) throws JsonException {
        return this.value(new Double(d));
    }

    public JsonWriter value(long l) throws JsonException {
        return this.value(new Long(l));
    }

    public JsonWriter value(Date date) throws JsonException {
        return this.value(new Long(date.getTime() / 1000L));
    }

    public JsonWriter value(ByteBuffer b) throws JsonException {
        b.mark();
        byte[] bytes = new byte[b.remaining()];
        b.get(bytes, 0, bytes.length);
        b.reset();
        return this.value(Encoders.base64EncodeText(bytes));
    }

    public JsonWriter value(Object o) throws JsonException {
        return this.append(JsonObject.valueToString(o));
    }
}

