/*
 * Decompiled with CFR 0.152.
 */
package org.qas.api.internal.util.json;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import org.qas.api.AuthClientException;
import org.qas.api.internal.util.json.JsonArray;
import org.qas.api.internal.util.json.JsonException;
import org.qas.api.internal.util.json.JsonObject;

public final class Jsons {
    private Jsons() {
        throw new AssertionError((Object)"The Jsons utilities must not be instantiated.");
    }

    public static <T> T toObject(Class<T> clazz, String source) throws JsonException {
        JsonObject jsonObect = new JsonObject(source);
        try {
            return Jsons.toObject(clazz, jsonObect);
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    private static <T> T toObject(Class<T> clazz, JsonObject jsonObject) throws JsonException, IllegalArgumentException, IllegalAccessException {
        T newObject;
        try {
            newObject = Jsons.createInstance(clazz);
        }
        catch (Exception e) {
            throw new AuthClientException("Failed to instantiate class", e);
        }
        for (Field objectField : clazz.getFields()) {
            Object fieldValue;
            String fieldName = objectField.getName();
            Class<?> fieldType = objectField.getType();
            try {
                fieldValue = Jsons.parseField(jsonObject, fieldType, fieldName);
            }
            catch (Exception e) {
                fieldValue = Jsons.parseField(jsonObject, fieldType, fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1));
            }
            objectField.set(newObject, fieldValue);
        }
        return newObject;
    }

    private static Object parseField(JsonObject jsonObject, Class<?> clazz, String key) throws JsonException, IllegalArgumentException, IllegalAccessException {
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return jsonObject.getBoolean(key);
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return jsonObject.getDouble(key);
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return jsonObject.getInt(key);
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return jsonObject.getLong(key);
        }
        if (clazz.equals(String.class)) {
            return jsonObject.getString(key);
        }
        if (clazz.equals(Character.class) || clazz.equals(Character.TYPE)) {
            return Character.valueOf(jsonObject.getString(key).charAt(0));
        }
        if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            JsonArray jsonArray = jsonObject.getJsonArray(key);
            Object array = Array.newInstance(componentType, jsonArray.length());
            for (int i = 0; i < jsonArray.length(); ++i) {
                Array.set(array, i, Jsons.parseField(jsonArray, componentType, i));
            }
            return array;
        }
        JsonObject nestedObject = jsonObject.getJsonObject(key);
        return Jsons.toObject(clazz, nestedObject);
    }

    private static Object parseField(JsonArray jsonArray, Class<?> clazz, int index) throws JsonException, IllegalArgumentException, IllegalAccessException {
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return jsonArray.getBoolean(index);
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return jsonArray.getDouble(index);
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return jsonArray.getInt(index);
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return jsonArray.getLong(index);
        }
        if (clazz.equals(String.class)) {
            return jsonArray.getString(index);
        }
        if (clazz.equals(Character.class) || clazz.equals(Character.TYPE)) {
            return Character.valueOf(jsonArray.getString(index).charAt(0));
        }
        if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            JsonArray nestedJSONArray = jsonArray.getJsonArray(index);
            LinkedList<Object> list = new LinkedList<Object>();
            for (int i = 0; i < jsonArray.length(); ++i) {
                list.add(Jsons.parseField(nestedJSONArray, componentType, i));
            }
            return list.toArray();
        }
        JsonObject nestedObject = jsonArray.getJsonObject(index);
        return Jsons.toObject(clazz, nestedObject);
    }

    private static <T> T createInstance(Class<T> clazz) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        T instanceToReturn = null;
        Class<?> enclosingClass = clazz.getEnclosingClass();
        if (enclosingClass != null) {
            Object instanceOfEnclosingClass = Jsons.createInstance(enclosingClass);
            Constructor<T> ctor = clazz.getConstructor(enclosingClass);
            if (ctor != null) {
                instanceToReturn = ctor.newInstance(instanceOfEnclosingClass);
            }
        } else {
            instanceToReturn = clazz.newInstance();
        }
        return instanceToReturn;
    }
}

