/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.auth;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.qas.api.AuthClientException;
import org.qas.qtest.api.auth.QTestCredentials;
import org.qas.qtest.api.auth.QTestCredentialsProvider;

public class QTestCredentialsProviderChain
implements QTestCredentialsProvider {
    private static final Logger LOG = Logger.getLogger(QTestCredentialsProviderChain.class.getName());
    private List<QTestCredentialsProvider> credentialsProviders = new LinkedList<QTestCredentialsProvider>();

    public QTestCredentialsProviderChain(QTestCredentialsProvider ... credentialsProviders) {
        if (credentialsProviders == null || credentialsProviders.length == 0) {
            throw new IllegalArgumentException("No credentials providers specified.");
        }
        for (QTestCredentialsProvider credentialsProvider : credentialsProviders) {
            this.credentialsProviders.add(credentialsProvider);
        }
    }

    @Override
    public QTestCredentials getCredentials() {
        for (QTestCredentialsProvider credentialsProvider : this.credentialsProviders) {
            try {
                QTestCredentials credentials = credentialsProvider.getCredentials();
                if (credentials.getToken() == null) continue;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Loading credentials from " + credentialsProvider.toString());
                }
                return credentials;
            }
            catch (Exception ex) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("Unable to load credentials from " + credentialsProvider.toString() + ":" + ex.getMessage());
            }
        }
        throw new AuthClientException("Unable to load qTest credentials from any provider in the chain.");
    }

    @Override
    public void refresh() {
        for (QTestCredentialsProvider credentialsProvider : this.credentialsProviders) {
            credentialsProvider.refresh();
        }
    }
}

