/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.authenticate.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.qas.api.ApiServiceRequest;
import org.qas.api.StringUtil;

public abstract class OAuthAuthenticateRequest
extends ApiServiceRequest {
    private static final String BASIC_AUTH_TOKEN = StringUtil.base64Encode("qtest-java-sdk:");
    protected final OAuthGrantType grantType;
    protected final String token;

    protected OAuthAuthenticateRequest(OAuthGrantType grantType, String token) {
        this.grantType = grantType;
        this.token = token;
    }

    public OAuthGrantType grantType() {
        return this.grantType;
    }

    public String getToken() {
        return this.token;
    }

    public Map<String, String> requestParams() {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("grant_type", this.grantType.type());
        this.appendInternalRequestParams(requestParams);
        return Collections.unmodifiableMap(requestParams);
    }

    protected abstract void appendInternalRequestParams(HashMap<String, String> var1);

    public static final class RefreshTokenAuthenticateRequest
    extends OAuthAuthenticateRequest {
        private final String refreshToken;

        public RefreshTokenAuthenticateRequest(String token, String refreshToken) {
            super(OAuthGrantType.REFRESH_TOKEN, token);
            this.refreshToken = refreshToken;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        @Override
        protected void appendInternalRequestParams(HashMap<String, String> requestParams) {
            requestParams.put("refresh_token", this.getRefreshToken());
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("RefreshTokenAuthenticateRequest{");
            sb.append("grantType=").append(this.grantType.type());
            sb.append(", token='").append(this.token).append('\'');
            sb.append(", refreshToken='").append(this.refreshToken).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }

    public static final class ClientCredentialsAuthenticateRequest
    extends OAuthAuthenticateRequest {
        public ClientCredentialsAuthenticateRequest(String token) {
            super(OAuthGrantType.CLIENT_CREDENTIALS, token);
        }

        @Override
        protected void appendInternalRequestParams(HashMap<String, String> requestParams) {
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("ClientCredentialsAuthenticateRequest{");
            sb.append("grantType=").append(this.grantType.type());
            sb.append(", token='").append(this.token).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }

    public static final class PasswordAuthenticateRequest
    extends OAuthAuthenticateRequest {
        private final String username;
        private final String password;

        public PasswordAuthenticateRequest(String username, String password) {
            super(OAuthGrantType.PASSWORD, BASIC_AUTH_TOKEN);
            this.username = username;
            this.password = password;
        }

        public PasswordAuthenticateRequest(String token, String username, String password) {
            super(OAuthGrantType.PASSWORD, token);
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        @Override
        protected void appendInternalRequestParams(HashMap<String, String> requestParams) {
            requestParams.put("username", this.getUsername());
            requestParams.put("password", this.getPassword());
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("PasswordAuthenticateRequest{");
            sb.append("grantType=").append(this.grantType.type());
            sb.append(", username='").append(this.username).append('\'');
            sb.append(", password='").append(this.password).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }

    public static enum OAuthGrantType {
        PASSWORD("password"),
        CLIENT_CREDENTIALS("client_credentials"),
        REFRESH_TOKEN("refresh_token");

        private String grantType;

        private OAuthGrantType(String grantType) {
            this.grantType = grantType;
        }

        public String type() {
            return this.grantType;
        }
    }
}

