/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.authenticate.model.transform;

import java.util.Locale;
import java.util.Map;
import org.qas.api.AuthClientException;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.authenticate.model.OAuthAuthenticateRequest;

public class OAuthAuthenticateRequestMarshaller
extends AbstractMarshaller<Request, OAuthAuthenticateRequest> {
    @Override
    protected void validateRequest(OAuthAuthenticateRequest in) throws Exception {
        if (in == null) {
            throw new AuthClientException("Invalid argument passed to call (...)");
        }
    }

    @Override
    protected void build(Request request, OAuthAuthenticateRequest in) {
        super.build(request, in);
        request.setHeader("Content-Type", "application/x-www-form-urlencoded");
        request.setHeader("Accept", "application/json");
        request.setHeader("Authorization", OAuthAuthenticateRequestMarshaller.normalizeToken(in.getToken(), "Basic"));
        request.setHttpMethod(HttpMethod.POST);
        Map<String, String> requestParams = in.requestParams();
        if (requestParams != null && !requestParams.isEmpty()) {
            for (Map.Entry<String, String> param : requestParams.entrySet()) {
                request.addParameter(param.getKey(), param.getValue());
            }
        }
    }

    @Override
    protected String getServiceName() {
        return "AuthenticateService";
    }

    @Override
    protected String getActionName() {
        return "Authenticate";
    }

    @Override
    protected String getContent(OAuthAuthenticateRequest in) throws Exception {
        return null;
    }

    @Override
    protected StringBuilder getResourcePath(OAuthAuthenticateRequest in, StringBuilder rpBuilder) {
        return rpBuilder.append("/oauth/token");
    }

    static String normalizeToken(String token, String prefix) {
        String tokenLc = token.toLowerCase();
        if (tokenLc.startsWith(prefix.toLowerCase(Locale.US) + " ")) {
            return token;
        }
        return String.format("%s %s", prefix, token);
    }
}

