/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.design.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.StringInputStream;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.design.model.CreateTestCaseRequest;
import org.qas.qtest.api.services.design.model.transform.AbstractTestCaseRequestMarshaller;

public final class CreateTestCaseRequestMarshaller
extends AbstractTestCaseRequestMarshaller<CreateTestCaseRequest> {
    @Override
    public Request marshall(CreateTestCaseRequest testCaseRequest) throws Exception {
        testCaseRequest = ApiPreconditions.notNull(testCaseRequest);
        CreateTestCaseRequestMarshaller.validateProjectId(testCaseRequest.getProjectId());
        ApiPreconditions.notNull(testCaseRequest.getTestCase(), "Invalid test-case instance passed to marshall(...)");
        Request request = this.createJsonRequest(testCaseRequest, "CreateTestCase", HttpMethod.POST);
        StringBuilder pathBuilder = new StringBuilder(this.createApiBasePathWithProject(testCaseRequest.getProjectId()));
        pathBuilder.append("/test-cases");
        request.setResourcePath(pathBuilder.toString());
        request.setContent(new StringInputStream(JsonMapper.toJson(testCaseRequest.getTestCase())));
        return request;
    }
}

