/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.design.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.StringInputStream;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.design.model.UpdateTestCaseRequest;
import org.qas.qtest.api.services.design.model.transform.AbstractTestCaseRequestMarshaller;

public final class UpdateTestCaseRequestMarshaller
extends AbstractTestCaseRequestMarshaller<UpdateTestCaseRequest> {
    @Override
    public Request marshall(UpdateTestCaseRequest testCaseRequest) throws Exception {
        testCaseRequest = ApiPreconditions.notNull(testCaseRequest);
        UpdateTestCaseRequestMarshaller.validateProjectId(testCaseRequest.getProjectId());
        UpdateTestCaseRequestMarshaller.validateTestCaseId(testCaseRequest.getTestCaseId());
        ApiPreconditions.notNull(testCaseRequest.getTestCase(), "Invalid test-case instance passed to marshall(...)");
        Request request = this.createJsonRequest(testCaseRequest, "UpdateTestCase", HttpMethod.PUT);
        StringBuilder pathBuilder = new StringBuilder(this.createApiBasePathWithProject(testCaseRequest.getProjectId()));
        pathBuilder.append("/test-cases/").append(testCaseRequest.getTestCaseId());
        request.setResourcePath(pathBuilder.toString());
        request.setContent(new StringInputStream(JsonMapper.toJson(testCaseRequest.getTestCase())));
        return request;
    }
}

