/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.execution;

import java.util.List;
import org.qas.api.AuthClientException;
import org.qas.api.AuthServiceException;
import org.qas.api.ClientConfiguration;
import org.qas.api.Request;
import org.qas.api.internal.util.google.base.Throwables;
import org.qas.api.transform.VoidJsonUnmarshaller;
import org.qas.qtest.api.auth.DefaultQTestCredentialsProviderChain;
import org.qas.qtest.api.auth.QTestCredentials;
import org.qas.qtest.api.auth.QTestCredentialsProvider;
import org.qas.qtest.api.auth.StaticQTestCredentialsProvider;
import org.qas.qtest.api.internal.QTestApiWebServiceClient;
import org.qas.qtest.api.services.execution.TestExecutionService;
import org.qas.qtest.api.services.execution.model.AutomationTestLogRequest;
import org.qas.qtest.api.services.execution.model.CreateTestCycleRequest;
import org.qas.qtest.api.services.execution.model.CreateTestRunRequest;
import org.qas.qtest.api.services.execution.model.CreateTestSuiteRequest;
import org.qas.qtest.api.services.execution.model.DeleteTestCycleRequest;
import org.qas.qtest.api.services.execution.model.DeleteTestRunRequest;
import org.qas.qtest.api.services.execution.model.DeleteTestSuiteRequest;
import org.qas.qtest.api.services.execution.model.ExecutionStatus;
import org.qas.qtest.api.services.execution.model.GetLastLogRequest;
import org.qas.qtest.api.services.execution.model.GetTestCycleRequest;
import org.qas.qtest.api.services.execution.model.GetTestRunRequest;
import org.qas.qtest.api.services.execution.model.GetTestSuiteRequest;
import org.qas.qtest.api.services.execution.model.ListExecutionStatusRequest;
import org.qas.qtest.api.services.execution.model.ListTestCycleRequest;
import org.qas.qtest.api.services.execution.model.ListTestRunRequest;
import org.qas.qtest.api.services.execution.model.ListTestSuiteRequest;
import org.qas.qtest.api.services.execution.model.MoveTestCycleRequest;
import org.qas.qtest.api.services.execution.model.MoveTestRunRequest;
import org.qas.qtest.api.services.execution.model.MoveTestSuiteRequest;
import org.qas.qtest.api.services.execution.model.SubmitTestLogRequest;
import org.qas.qtest.api.services.execution.model.TestCycle;
import org.qas.qtest.api.services.execution.model.TestLog;
import org.qas.qtest.api.services.execution.model.TestRun;
import org.qas.qtest.api.services.execution.model.TestSuite;
import org.qas.qtest.api.services.execution.model.UpdateTestCycleRequest;
import org.qas.qtest.api.services.execution.model.UpdateTestRunRequest;
import org.qas.qtest.api.services.execution.model.UpdateTestSuiteRequest;
import org.qas.qtest.api.services.execution.model.transform.AutomationTestLogRequestMarshaller;
import org.qas.qtest.api.services.execution.model.transform.CreateTestCycleRequestMarshaller;
import org.qas.qtest.api.services.execution.model.transform.CreateTestRunRequestMarshaller;
import org.qas.qtest.api.services.execution.model.transform.CreateTestSuiteRequestMarshaller;
import org.qas.qtest.api.services.execution.model.transform.DeleteTestCycleRequestMarshaller;
import org.qas.qtest.api.services.execution.model.transform.DeleteTestRunRequestMarshaller;
import org.qas.qtest.api.services.execution.model.transform.DeleteTestSuiteRequestMarshaller;
import org.qas.qtest.api.services.execution.model.transform.GetLastLogRequestMarshaller;
import org.qas.qtest.api.services.execution.model.transform.GetTestCycleRequestMarshaller;
import org.qas.qtest.api.services.execution.model.transform.GetTestRunRequestMarshaller;
import org.qas.qtest.api.services.execution.model.transform.GetTestSuiteRequestMarshaller;
import org.qas.qtest.api.services.execution.model.transform.ListExecutionStatusJsonUnmarshaller;
import org.qas.qtest.api.services.execution.model.transform.ListExecutionStatusRequestMarshaller;
import org.qas.qtest.api.services.execution.model.transform.ListTestCycleJsonUnmarshaller;
import org.qas.qtest.api.services.execution.model.transform.ListTestCycleRequestMarshaller;
import org.qas.qtest.api.services.execution.model.transform.ListTestRunJsonUnmarshaller;
import org.qas.qtest.api.services.execution.model.transform.ListTestRunRequestMarshaller;
import org.qas.qtest.api.services.execution.model.transform.ListTestSuiteJsonUnmarshaller;
import org.qas.qtest.api.services.execution.model.transform.ListTestSuiteRequestMarshaller;
import org.qas.qtest.api.services.execution.model.transform.MoveTestCycleRequestMarshaller;
import org.qas.qtest.api.services.execution.model.transform.MoveTestRunRequestMarshaller;
import org.qas.qtest.api.services.execution.model.transform.MoveTestSuiteRequestMarshaller;
import org.qas.qtest.api.services.execution.model.transform.SubmitTestLogRequestMarshaller;
import org.qas.qtest.api.services.execution.model.transform.TestCycleJsonUnmarshaller;
import org.qas.qtest.api.services.execution.model.transform.TestLogJsonUnmarshaller;
import org.qas.qtest.api.services.execution.model.transform.TestRunJsonUnmarshaller;
import org.qas.qtest.api.services.execution.model.transform.TestSuiteJsonUnmarshaller;
import org.qas.qtest.api.services.execution.model.transform.UpdateTestCycleRequestMarshaller;
import org.qas.qtest.api.services.execution.model.transform.UpdateTestRunRequestMarshaller;
import org.qas.qtest.api.services.execution.model.transform.UpdateTestSuiteRequestMarshaller;

public class TestExecutionServiceClient
extends QTestApiWebServiceClient<TestExecutionServiceClient>
implements TestExecutionService {
    public TestExecutionServiceClient() {
        this(new DefaultQTestCredentialsProviderChain(), new ClientConfiguration());
    }

    public TestExecutionServiceClient(ClientConfiguration clientConfiguration) {
        this(new DefaultQTestCredentialsProviderChain(), clientConfiguration);
    }

    public TestExecutionServiceClient(QTestCredentials credentials) {
        this(credentials, new ClientConfiguration());
    }

    public TestExecutionServiceClient(QTestCredentials credentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.credentialsProvider = new StaticQTestCredentialsProvider(credentials);
        this.init();
    }

    public TestExecutionServiceClient(QTestCredentialsProvider credentialsProvider) {
        this(credentialsProvider, new ClientConfiguration());
    }

    public TestExecutionServiceClient(QTestCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.credentialsProvider = credentialsProvider;
        this.init();
    }

    @Override
    public TestLog submitAutomationTestLog(AutomationTestLogRequest automationTestLogRequest) throws AuthServiceException {
        try {
            Object request = new AutomationTestLogRequestMarshaller().marshall(automationTestLogRequest);
            return this.invoke((Request)request, TestLogJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute request", ex);
        }
    }

    @Override
    public TestLog submitTestLog(SubmitTestLogRequest submitTestLogRequest) throws AuthServiceException {
        try {
            Object request = new SubmitTestLogRequestMarshaller().marshall(submitTestLogRequest);
            return this.invoke((Request)request, TestLogJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute request", ex);
        }
    }

    @Override
    public TestLog getLastLog(GetLastLogRequest getLastLogRequest) throws AuthServiceException {
        try {
            Object request = new GetLastLogRequestMarshaller().marshall(getLastLogRequest);
            return this.invoke((Request)request, TestLogJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during get last log", ex);
        }
    }

    @Override
    public List<ExecutionStatus> listExecutionStatus(ListExecutionStatusRequest executionStatusRequest) throws AuthServiceException {
        try {
            Object request = new ListExecutionStatusRequestMarshaller().marshall(executionStatusRequest);
            return this.invoke((Request)request, ListExecutionStatusJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute list execution status request", ex);
        }
    }

    @Override
    public List<TestRun> listTestRun(ListTestRunRequest testRunRequest) throws AuthServiceException {
        try {
            Request request = new ListTestRunRequestMarshaller().marshall(testRunRequest);
            return this.invoke(request, ListTestRunJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute list test run request", ex);
        }
    }

    @Override
    public TestRun getTestRun(GetTestRunRequest getTestRunRequest) throws AuthServiceException {
        try {
            Request request = new GetTestRunRequestMarshaller().marshall(getTestRunRequest);
            return this.invoke(request, TestRunJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during get test-run request", ex);
        }
    }

    @Override
    public TestRun createTestRun(CreateTestRunRequest testRunRequest) throws AuthServiceException {
        try {
            Request request = new CreateTestRunRequestMarshaller().marshall(testRunRequest);
            return this.invoke(request, TestRunJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during create test-run request", ex);
        }
    }

    @Override
    public TestRun updateTestRun(UpdateTestRunRequest testRunRequest) throws AuthServiceException {
        try {
            Request request = new UpdateTestRunRequestMarshaller().marshall(testRunRequest);
            return this.invoke(request, TestRunJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during update test-run request", ex);
        }
    }

    @Override
    public TestRun moveTestRun(MoveTestRunRequest testRunRequest) throws AuthServiceException {
        try {
            Request request = new MoveTestRunRequestMarshaller().marshall(testRunRequest);
            return this.invoke(request, TestRunJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during move test-run request", ex);
        }
    }

    @Override
    public void deleteTestRun(DeleteTestRunRequest testRunRequest) throws AuthServiceException {
        try {
            Request request = new DeleteTestRunRequestMarshaller().marshall(testRunRequest);
            this.invoke(request, new VoidJsonUnmarshaller());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during delete test-run request", ex);
        }
    }

    @Override
    public TestSuite createTestSuite(CreateTestSuiteRequest testSuiteRequest) throws AuthServiceException {
        try {
            Request request = new CreateTestSuiteRequestMarshaller().marshall(testSuiteRequest);
            return this.invoke(request, TestSuiteJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute create test suite request", ex);
        }
    }

    @Override
    public TestSuite updateTestSuite(UpdateTestSuiteRequest testSuiteRequest) throws AuthServiceException {
        try {
            Request request = new UpdateTestSuiteRequestMarshaller().marshall(testSuiteRequest);
            return this.invoke(request, TestSuiteJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute update test suite request", ex);
        }
    }

    @Override
    public TestSuite moveTestSuite(MoveTestSuiteRequest testSuiteRequest) throws AuthServiceException {
        try {
            Request request = new MoveTestSuiteRequestMarshaller().marshall(testSuiteRequest);
            return this.invoke(request, TestSuiteJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute move test suite request", ex);
        }
    }

    @Override
    public TestSuite getTestSuite(GetTestSuiteRequest testSuiteRequest) throws AuthServiceException {
        try {
            Request request = new GetTestSuiteRequestMarshaller().marshall(testSuiteRequest);
            return this.invoke(request, TestSuiteJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute get test suite request", ex);
        }
    }

    @Override
    public List<TestSuite> listTestSuite(ListTestSuiteRequest testSuiteRequest) throws AuthServiceException {
        try {
            Request request = new ListTestSuiteRequestMarshaller().marshall(testSuiteRequest);
            return this.invoke(request, ListTestSuiteJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute list test suite request", ex);
        }
    }

    @Override
    public void deleteTestSuite(DeleteTestSuiteRequest testSuiteRequest) throws AuthServiceException {
        try {
            Request request = new DeleteTestSuiteRequestMarshaller().marshall(testSuiteRequest);
            this.invoke(request, new VoidJsonUnmarshaller());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute delete test suite request", ex);
        }
    }

    @Override
    public TestCycle getTestCycle(GetTestCycleRequest testCycleRequest) throws AuthServiceException {
        try {
            Request request = new GetTestCycleRequestMarshaller().marshall(testCycleRequest);
            return this.invoke(request, TestCycleJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute get test cycle request", ex);
        }
    }

    @Override
    public List<TestCycle> listTestCycle(ListTestCycleRequest testCycleRequest) throws AuthServiceException {
        try {
            Request request = new ListTestCycleRequestMarshaller().marshall(testCycleRequest);
            return this.invoke(request, ListTestCycleJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute list test cycle request", ex);
        }
    }

    @Override
    public TestCycle createTestCycle(CreateTestCycleRequest testCycleRequest) throws AuthServiceException {
        try {
            Request request = new CreateTestCycleRequestMarshaller().marshall(testCycleRequest);
            return this.invoke(request, TestCycleJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute create test cycle request", ex);
        }
    }

    @Override
    public TestCycle updateTestCycle(UpdateTestCycleRequest testCycleRequest) throws AuthServiceException {
        try {
            Request request = new UpdateTestCycleRequestMarshaller().marshall(testCycleRequest);
            return this.invoke(request, TestCycleJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute update test cycle request", ex);
        }
    }

    @Override
    public TestCycle moveTestCycle(MoveTestCycleRequest testCycleRequest) throws AuthServiceException {
        try {
            Request request = new MoveTestCycleRequestMarshaller().marshall(testCycleRequest);
            return this.invoke(request, TestCycleJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute move test cycle request", ex);
        }
    }

    @Override
    public void deleteTestCycle(DeleteTestCycleRequest testCycleRequest) throws AuthServiceException {
        try {
            Request request = new DeleteTestCycleRequestMarshaller().marshall(testCycleRequest);
            this.invoke(request, new VoidJsonUnmarshaller());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute delete test cycle request", ex);
        }
    }
}

