/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.execution.model.transform;

import java.util.Set;
import org.qas.api.ApiServiceRequest;
import org.qas.api.AuthClientException;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.qtest.api.internal.model.ArtifactLevel;
import org.qas.qtest.api.internal.model.transform.AbstractQTestApiRequestMarshaller;
import org.qas.qtest.api.internal.util.ApiPreconditions;

public abstract class AbstractTestExecutionRequestMarshaller<T extends ApiServiceRequest>
extends AbstractQTestApiRequestMarshaller<T> {
    static void validateArtifactLevel(ArtifactLevel artifactLevel, Set<ArtifactLevel> allowLevels) throws AuthClientException {
        ApiPreconditions.checkArgument(artifactLevel != null && allowLevels.contains((Object)artifactLevel), "Invalid artifact type passed to marshall(...)");
    }

    static void validateArtifact(ArtifactLevel artifactLevel, Long artifactId) throws AuthClientException {
        boolean valid = artifactLevel == ArtifactLevel.ROOT ? artifactId == null || artifactId == 0L : artifactId != null && artifactId > 0L;
        ApiPreconditions.checkArgument(valid, "Invalid artifact id passed to marshall(...)");
    }

    protected Request createJsonRequest(T requestType, String requestAction, HttpMethod requestMethod) {
        return this.createJsonRequest(requestType, "TestExecutionService", requestAction, requestMethod);
    }

    protected StringBuilder createApiPathBuilder(Long projectId) {
        StringBuilder pathBuilder = new StringBuilder(this.createApiBasePathWithProject(projectId));
        pathBuilder.append("/").append(this.getArtifactPath());
        return pathBuilder;
    }

    protected abstract String getArtifactPath();
}

