/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.execution.model.transform;

import java.util.Date;
import org.qas.api.AuthClientException;
import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.Dates;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.execution.model.AutomationTestLogRequest;

public final class AutomationTestLogRequestMarshaller
extends AbstractMarshaller<Request, AutomationTestLogRequest> {
    @Override
    protected void validateRequest(AutomationTestLogRequest in) throws Exception {
        if (in == null) {
            throw new AuthClientException("Invalid argument passed to marshall(...)");
        }
        if (in.getProjectId() == null || in.getProjectId() <= 0L) {
            throw new AuthClientException("Invalid project id passed to marshall(...)");
        }
        if (in.getAutomationTestLog() == null) {
            throw new AuthClientException("Invalid automation test log passed to marshall(...)");
        }
    }

    @Override
    protected void build(Request request, AutomationTestLogRequest in) {
        request.setHttpMethod(HttpMethod.POST);
        if (in.isSuitePerDay()) {
            request.addParameter("suitePerDay", "true");
            Date suiteDate = in.getSuiteDate();
            if (suiteDate == null) {
                suiteDate = new Date();
            }
            request.addParameter("suiteDate", Dates.getInstance().formaturlDate(suiteDate));
        }
        if (in.getForceUpdateVersion() != null) {
            request.addParameter("forceUpdateVersion", in.getForceUpdateVersion().toString());
        }
    }

    @Override
    protected String getServiceName() {
        return "TestExecutionService";
    }

    @Override
    protected String getActionName() {
        return "SummitAutomationTestLog";
    }

    @Override
    protected String getContent(AutomationTestLogRequest in) throws Exception {
        return JsonMapper.toJson(in.getAutomationTestLog());
    }

    @Override
    protected StringBuilder getResourcePath(AutomationTestLogRequest in, StringBuilder rpBuilder) {
        rpBuilder.append("/api/v3/projects/").append(in.getProjectId()).append("/test-runs/");
        if (in.getTestRunId() == null || in.getTestRunId() <= 0L) {
            rpBuilder.append("0/auto-test-logs");
        } else {
            rpBuilder.append(in.getTestRunId()).append("/auto-test-logs");
        }
        return rpBuilder;
    }
}

