/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.host.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.host.model.ActivateAutomationAgentRequest;

public class ActivateAutomationAgentRequestMarshaller
extends AbstractMarshaller<Request, ActivateAutomationAgentRequest> {
    private static String API_VERSION = "v3";
    private static String ACTIVE_URL = "/api/%s/projects/%d/automation/hosts/%d/agents/%d/activate";
    private static String DEACTIVE_URL = "/api/%s/projects/%d/automation/hosts/%d/agents/%d/deactivate";

    private String getApiUrl(ActivateAutomationAgentRequest activeRequest) {
        String url = activeRequest.getActive() != false ? ACTIVE_URL : DEACTIVE_URL;
        return String.format(url, API_VERSION, activeRequest.getProjectId(), activeRequest.getHostServerId(), activeRequest.getAgentServerId());
    }

    @Override
    protected void validateRequest(ActivateAutomationAgentRequest in) throws Exception {
        if (in == null) {
            throw new AuthClientException("Invalid argument passed to marshall(...)");
        }
        if (in.getAgentServerId() == null || in.getAgentServerId() <= 0L) {
            throw new AuthClientException("Invalid agent server identifier passed to marshall(...)");
        }
        if (in.getHostServerId() == null || in.getHostServerId() <= 0L) {
            throw new AuthClientException("Invalid host server identifier passed to marshall(...)");
        }
        if (in.getProjectId() == null || in.getProjectId() <= 0L) {
            throw new AuthClientException("Invalid project identifier passed to marshall(...)");
        }
        if (in.getActive() == null) {
            throw new AuthClientException("Invalid active flag passed to marshall(...)");
        }
    }

    @Override
    protected void build(Request request, ActivateAutomationAgentRequest in) {
        request.setHttpMethod(HttpMethod.POST);
    }

    @Override
    protected String getServiceName() {
        return "HostService";
    }

    @Override
    protected String getActionName() {
        return "ActivateAgent";
    }

    @Override
    protected String getContent(ActivateAutomationAgentRequest in) throws Exception {
        return null;
    }

    @Override
    protected StringBuilder getResourcePath(ActivateAutomationAgentRequest in, StringBuilder rpBuilder) {
        return rpBuilder.append(this.getApiUrl(in));
    }
}

