/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.host.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.Dates;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.host.model.ListJobRequest;

public class ListJobRequestMarshaller
extends AbstractMarshaller<Request, ListJobRequest> {
    private static final String API_URL = "/api/v3/automation/hosts/%d/jobs";

    @Override
    protected void validateRequest(ListJobRequest in) throws Exception {
        if (in == null) {
            throw new AuthClientException("Invalid argument passed to marshall(...)");
        }
        if (in.getHostServerId() == null) {
            throw new AuthClientException("Invalid host server identifier passed to marshall(...)");
        }
    }

    @Override
    protected void build(Request request, ListJobRequest in) {
        request.setHttpMethod(HttpMethod.GET);
        if (in.getStartDate() != null) {
            request.addParameter("start_date", Dates.getInstance().formatAlternateIso8601Date(in.getStartDate()));
        }
        request.addParameter("end_date", Dates.getInstance().formatAlternateIso8601Date(in.getEndDate()));
    }

    @Override
    protected String getServiceName() {
        return "HostService";
    }

    @Override
    protected String getActionName() {
        return "ListJob";
    }

    @Override
    protected String getContent(ListJobRequest in) throws Exception {
        return null;
    }

    @Override
    protected StringBuilder getResourcePath(ListJobRequest in, StringBuilder rpBuilder) {
        return rpBuilder.append(String.format(API_URL, in.getHostServerId()));
    }
}

