/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.project.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.project.model.CreateCustomFieldRequest;

public final class CreateCustomFieldRequestMarshaller
extends AbstractMarshaller<Request, CreateCustomFieldRequest> {
    @Override
    protected void validateRequest(CreateCustomFieldRequest in) throws Exception {
        if (in == null) {
            throw new AuthClientException("Invalid request passed to call(...)");
        }
        if (in.getProjectId() == null || in.getProjectId() == 0L) {
            throw new AuthClientException("Invalid project identifier passed to call(...)");
        }
        if (in.getObjectType() == null) {
            throw new AuthClientException("Invalid object type passed to call(...)");
        }
        if (in.getField() == null) {
            throw new AuthClientException("Invalid field value passed to call(...)");
        }
    }

    @Override
    protected void build(Request request, CreateCustomFieldRequest in) {
        request.setHttpMethod(HttpMethod.POST);
    }

    @Override
    protected String getServiceName() {
        return "ProjectService";
    }

    @Override
    protected String getActionName() {
        return "CreateCustomField";
    }

    @Override
    protected String getContent(CreateCustomFieldRequest in) throws Exception {
        return JsonMapper.toJson(in.getField());
    }

    @Override
    protected StringBuilder getResourcePath(CreateCustomFieldRequest in, StringBuilder rpBuilder) {
        return rpBuilder.append("/api/v3/projects/").append(in.getProjectId()).append("/settings/").append(in.getObjectType().getPath()).append("/fields");
    }
}

