/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.requirement;

import java.util.List;
import org.qas.api.AuthClientException;
import org.qas.api.AuthServiceException;
import org.qas.api.ClientConfiguration;
import org.qas.api.Request;
import org.qas.api.internal.util.google.base.Throwables;
import org.qas.qtest.api.auth.DefaultQTestCredentialsProviderChain;
import org.qas.qtest.api.auth.QTestCredentials;
import org.qas.qtest.api.auth.QTestCredentialsProvider;
import org.qas.qtest.api.auth.StaticQTestCredentialsProvider;
import org.qas.qtest.api.internal.QTestApiWebServiceClient;
import org.qas.qtest.api.internal.model.CreateObjectCommentRequest;
import org.qas.qtest.api.internal.model.Field;
import org.qas.qtest.api.internal.model.transform.CreateObjectCommentRequestMarshaller;
import org.qas.qtest.api.internal.model.transform.ListFieldJsonUnmarshaller;
import org.qas.qtest.api.services.requirement.RequirementService;
import org.qas.qtest.api.services.requirement.model.CreateRequirementRequest;
import org.qas.qtest.api.services.requirement.model.GetRequirementFieldsRequest;
import org.qas.qtest.api.services.requirement.model.Requirement;
import org.qas.qtest.api.services.requirement.model.transform.CreateRequirementRequestMarshaller;
import org.qas.qtest.api.services.requirement.model.transform.GetRequirementFieldsRequestMarshaller;
import org.qas.qtest.api.services.requirement.model.transform.RequirementJsonUnmarshaller;

public class RequirementServiceClient
extends QTestApiWebServiceClient<RequirementServiceClient>
implements RequirementService {
    public RequirementServiceClient() {
        this(new DefaultQTestCredentialsProviderChain(), new ClientConfiguration());
    }

    public RequirementServiceClient(ClientConfiguration clientConfiguration) {
        this(new DefaultQTestCredentialsProviderChain(), clientConfiguration);
    }

    public RequirementServiceClient(QTestCredentials credentials) {
        this(credentials, new ClientConfiguration());
    }

    public RequirementServiceClient(QTestCredentials credentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.credentialsProvider = new StaticQTestCredentialsProvider(credentials);
        this.init();
    }

    public RequirementServiceClient(QTestCredentialsProvider credentialsProvider) {
        this(credentialsProvider, new ClientConfiguration());
    }

    public RequirementServiceClient(QTestCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.credentialsProvider = credentialsProvider;
        this.init();
    }

    @Override
    public List<Field> getRequirementFields(GetRequirementFieldsRequest getRequirementFieldsRequest) throws AuthServiceException {
        try {
            Object request = new GetRequirementFieldsRequestMarshaller().marshall(getRequirementFieldsRequest);
            return this.invoke((Request)request, ListFieldJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown exception occurs during getting requirement fields", ex);
        }
    }

    @Override
    public Requirement createRequirement(CreateRequirementRequest createRequirementRequest) throws AuthServiceException {
        try {
            Object request = new CreateRequirementRequestMarshaller().marshall(createRequirementRequest);
            return this.invoke((Request)request, RequirementJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown exception occurs during create requirement data", ex);
        }
    }

    @Override
    public Requirement addComment(CreateObjectCommentRequest createObjectCommentRequest) throws AuthServiceException {
        try {
            Object request = new CreateObjectCommentRequestMarshaller("RequirementService").marshall(createObjectCommentRequest);
            return this.invoke((Request)request, RequirementJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown exception occurs d\u1ee7ing creating requirement comment", ex);
        }
    }
}

