/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.user;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.qas.api.AuthServiceException;
import org.qas.api.ClientConfiguration;
import org.qas.api.handler.AsyncHandler;
import org.qas.qtest.api.auth.DefaultQTestCredentialsProviderChain;
import org.qas.qtest.api.auth.QTestCredentials;
import org.qas.qtest.api.auth.QTestCredentialsProvider;
import org.qas.qtest.api.auth.StaticQTestCredentialsProvider;
import org.qas.qtest.api.services.user.UserServiceAsync;
import org.qas.qtest.api.services.user.UserServiceClient;
import org.qas.qtest.api.services.user.model.AssignToProjectRequest;
import org.qas.qtest.api.services.user.model.AssignToProjectResult;
import org.qas.qtest.api.services.user.model.CreateUserRequest;
import org.qas.qtest.api.services.user.model.User;

public class UserServiceAsyncClient
extends UserServiceClient
implements UserServiceAsync {
    public UserServiceAsyncClient() {
        this(new DefaultQTestCredentialsProviderChain(), new ClientConfiguration(), Executors.newCachedThreadPool());
    }

    public UserServiceAsyncClient(ExecutorService executorService) {
        this(new DefaultQTestCredentialsProviderChain(), new ClientConfiguration(), executorService);
    }

    public UserServiceAsyncClient(ClientConfiguration clientConfiguration) {
        this(new DefaultQTestCredentialsProviderChain(), clientConfiguration, Executors.newCachedThreadPool());
    }

    public UserServiceAsyncClient(ClientConfiguration clientConfiguration, ExecutorService executorService) {
        this(new DefaultQTestCredentialsProviderChain(), clientConfiguration, executorService);
    }

    public UserServiceAsyncClient(QTestCredentials credentials) {
        this(credentials, new ClientConfiguration(), Executors.newCachedThreadPool());
    }

    public UserServiceAsyncClient(QTestCredentials credentials, ExecutorService executorService) {
        this(credentials, new ClientConfiguration(), executorService);
    }

    public UserServiceAsyncClient(QTestCredentials credentials, ClientConfiguration clientConfiguration) {
        this(credentials, clientConfiguration, Executors.newCachedThreadPool());
    }

    public UserServiceAsyncClient(QTestCredentials credentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        this(new StaticQTestCredentialsProvider(credentials), clientConfiguration, executorService);
    }

    public UserServiceAsyncClient(QTestCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        this(credentialsProvider, clientConfiguration, Executors.newCachedThreadPool());
    }

    public UserServiceAsyncClient(QTestCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(credentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    @Override
    public Future<User> createAsync(final CreateUserRequest createUserRequest) throws AuthServiceException {
        return this.executorService.submit(new Callable<User>(){

            @Override
            public User call() throws Exception {
                return UserServiceAsyncClient.this.create(createUserRequest);
            }
        });
    }

    @Override
    public Future<User> createAsync(final CreateUserRequest createUserRequest, final AsyncHandler<CreateUserRequest, User> asyncHandler) throws AuthServiceException {
        return this.executorService.submit(new Callable<User>(){

            @Override
            public User call() throws Exception {
                User result;
                try {
                    result = UserServiceAsyncClient.this.create(createUserRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createUserRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<AssignToProjectResult> assignToProjectAsync(final AssignToProjectRequest assignToProjectRequest) throws AuthServiceException {
        return this.executorService.submit(new Callable<AssignToProjectResult>(){

            @Override
            public AssignToProjectResult call() throws Exception {
                return UserServiceAsyncClient.this.assignToProject(assignToProjectRequest);
            }
        });
    }

    @Override
    public Future<AssignToProjectResult> assignToProjectAsync(final AssignToProjectRequest assignToProjectRequest, final AsyncHandler<AssignToProjectRequest, AssignToProjectResult> asyncHandler) throws AuthServiceException {
        return this.executorService.submit(new Callable<AssignToProjectResult>(){

            @Override
            public AssignToProjectResult call() throws Exception {
                AssignToProjectResult result;
                try {
                    result = UserServiceAsyncClient.this.assignToProject(assignToProjectRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(assignToProjectRequest, result);
                return result;
            }
        });
    }
}

