/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.builder.core;

import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import org.reficio.ws.builder.SoapBuilder;
import org.reficio.ws.builder.SoapOperationBuilder;
import org.reficio.ws.builder.core.SoapOperationImpl;

public class SoapUtils {
    public static String normalizeSoapAction(String soapAction) {
        String normalizedSoapAction = "";
        if (soapAction != null && soapAction.length() > 0) {
            normalizedSoapAction = soapAction;
            if (soapAction.charAt(0) == '\"' && soapAction.charAt(soapAction.length() - 1) == '\"') {
                normalizedSoapAction = soapAction.substring(1, soapAction.length() - 1).trim();
            }
        }
        return normalizedSoapAction;
    }

    public static String getSOAPActionUri(BindingOperation operation) {
        List extensions = operation.getExtensibilityElements();
        if (extensions != null) {
            for (int i = 0; i < extensions.size(); ++i) {
                ExtensibilityElement extElement = (ExtensibilityElement)extensions.get(i);
                if (extElement instanceof SOAPOperation) {
                    SOAPOperation soapOp = (SOAPOperation)extElement;
                    return soapOp.getSoapActionURI();
                }
                if (!(extElement instanceof SOAP12Operation)) continue;
                SOAP12Operation soapOp = (SOAP12Operation)extElement;
                return soapOp.getSoapActionURI();
            }
        }
        return null;
    }

    public static SoapOperationBuilder createOperation(SoapBuilder builder, Binding binding, BindingOperation operation, String soapAction) {
        return SoapOperationImpl.create(builder, binding, operation, soapAction);
    }
}

