/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.activation.plugin.handler;

import com.kms.katalon.activation.plugin.constant.ActivationMessageConstants;
import com.kms.katalon.activation.plugin.models.KStoreApiKeyCredentials;
import com.kms.katalon.activation.plugin.models.ReloadItem;
import com.kms.katalon.activation.plugin.service.PluginService;
import com.kms.katalon.logging.LogUtil;
import jakarta.inject.Inject;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class ConsoleModeReloadPluginsHandler {
    @Inject
    private IEclipseContext context;

    public void reload(String apiKey) {
        try {
            LogUtil.printOutputLine((String)"Start reloading plugins...");
            KStoreApiKeyCredentials credentials = new KStoreApiKeyCredentials();
            credentials.setApiKey(apiKey);
            PluginService pluginService = PluginService.getInstance();
            ContextInjectionFactory.inject((Object)pluginService, (IEclipseContext)this.context);
            List<ReloadItem> reloadPluginResults = pluginService.reloadPlugins(credentials, (IProgressMonitor)new NullProgressMonitor());
            reloadPluginResults.stream().forEach(result -> {
                String pluginName = result.getPlugin().getName();
                if (result.isPluginInstalled()) {
                    LogUtil.printOutputLine((String)MessageFormat.format(ActivationMessageConstants.MSG_PLUGIN_HAS_BEEN_INSTALLED, pluginName));
                } else {
                    LogUtil.printOutputLine((String)MessageFormat.format(ActivationMessageConstants.MSG_PLUGIN_HAS_BEEN_UNINSTALLED, pluginName));
                }
            });
        }
        catch (Exception e) {
            LogUtil.printAndLogError((Throwable)e, (String)"Failed to reload plugins.");
        }
    }
}

