/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.activation.plugin.service;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.kms.katalon.activation.plugin.models.KStoreLicense;
import com.kms.katalon.activation.plugin.models.KStorePlugin;
import com.kms.katalon.activation.plugin.models.KStorePluginVersion;
import com.kms.katalon.activation.plugin.models.KStoreProduct;
import java.lang.reflect.Type;

public class KStorePluginDeserialization
implements JsonDeserializer<KStorePlugin> {
    public KStorePlugin deserialize(JsonElement jsElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        KStorePlugin pluginStore = new KStorePlugin();
        JsonObject jsObject = jsElement.getAsJsonObject();
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        pluginStore.setId(jsObject.get("id").getAsLong());
        pluginStore.setStatus(jsObject.get("status").getAsString());
        JsonElement expDate = jsObject.get("expiration_date");
        if (expDate != null && !expDate.isJsonNull()) {
            pluginStore.setExpirationDate(expDate.getAsString());
        }
        pluginStore.setCreatedAt(jsObject.get("created_at").getAsString());
        pluginStore.setUpdatedAt(jsObject.get("updated_at").getAsString());
        pluginStore.setActive(jsObject.get("active").getAsBoolean());
        Type ksType = new TypeToken<KStoreProduct>(){}.getType();
        KStoreProduct product = (KStoreProduct)gson.fromJson(jsObject.get("product"), ksType);
        pluginStore.setProduct(product);
        ksType = new TypeToken<KStoreLicense>(){}.getType();
        KStoreLicense licenseType = (KStoreLicense)gson.fromJson(jsObject.get("license_type"), ksType);
        pluginStore.setLicenseType(licenseType);
        KStorePluginVersion latestCompatibleVersion = (KStorePluginVersion)new Gson().fromJson((JsonElement)jsObject.get("latest_compatible_version").getAsJsonObject(), KStorePluginVersion.class);
        pluginStore.setLatestCompatibleVersion(latestCompatibleVersion);
        pluginStore.setFree(jsObject.get("free").getAsBoolean());
        pluginStore.setTrial(jsObject.get("trial").getAsBoolean());
        pluginStore.setPaid(jsObject.get("paid").getAsBoolean());
        pluginStore.setExpired(jsObject.get("expired").getAsBoolean());
        JsonElement remainingDay = jsObject.get("remaining_day");
        if (remainingDay != null && !remainingDay.isJsonNull()) {
            pluginStore.setRemainingDay(remainingDay.getAsInt());
        }
        pluginStore.setDownloadUrl(jsObject.get("download_url").getAsString());
        return pluginStore;
    }
}

