/*
 * Decompiled with CFR 0.152.
 */
package atu.testrecorder.media.avi;

import atu.testrecorder.media.AbstractVideoCodec;
import atu.testrecorder.media.Buffer;
import atu.testrecorder.media.Format;
import atu.testrecorder.media.VideoFormat;
import atu.testrecorder.media.avi.DataChunkOutputStream;
import atu.testrecorder.media.io.ByteArrayImageOutputStream;
import atu.testrecorder.media.io.SeekableByteArrayOutputStream;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.zip.DeflaterOutputStream;

public class TechSmithCodec
extends AbstractVideoCodec {
    private ByteArrayImageOutputStream temp = new ByteArrayImageOutputStream(ByteOrder.LITTLE_ENDIAN);
    private Object previousPixels;

    @Override
    public Format setInputFormat(Format f) {
        VideoFormat vf;
        if (f instanceof VideoFormat && BufferedImage.class.isAssignableFrom((vf = (VideoFormat)f).getDataClass())) {
            return super.setInputFormat(new VideoFormat("image", vf.getDataClass(), vf.getWidth(), vf.getHeight(), vf.getDepth()));
        }
        return super.setInputFormat(null);
    }

    @Override
    public Format setOutputFormat(Format f) {
        if (f instanceof VideoFormat) {
            VideoFormat vf = (VideoFormat)f;
            int depth = vf.getDepth();
            depth = depth <= 8 ? 8 : (depth <= 16 ? 16 : 24);
            return super.setOutputFormat(new VideoFormat("tscc", byte[].class, vf.getWidth(), vf.getHeight(), depth));
        }
        return super.setOutputFormat(null);
    }

    @Override
    public void process(Buffer in, Buffer out) {
        Rectangle r;
        int scanlineStride;
        if ((in.flags & 2) != 0) {
            out.flags = 2;
            return;
        }
        out.format = this.outputFormat;
        SeekableByteArrayOutputStream tmp = out.data instanceof byte[] ? new SeekableByteArrayOutputStream((byte[])out.data) : new SeekableByteArrayOutputStream();
        VideoFormat vf = (VideoFormat)this.outputFormat;
        if (in.data instanceof BufferedImage) {
            BufferedImage image = (BufferedImage)in.data;
            WritableRaster raster = image.getRaster();
            scanlineStride = raster.getSampleModel().getWidth();
            r = raster.getBounds();
            r.x -= raster.getSampleModelTranslateX();
            r.y -= raster.getSampleModelTranslateY();
        } else {
            r = new Rectangle(0, 0, vf.getWidth(), vf.getHeight());
            scanlineStride = vf.getWidth();
        }
        int offset = r.x + r.y * scanlineStride;
        try {
            switch (vf.getDepth()) {
                case 8: {
                    Object[] pixels = this.getIndexed8(in);
                    if (pixels == null) {
                        out.flags = 2;
                        return;
                    }
                    if ((in.flags & 0x10) != 0 || this.previousPixels == null) {
                        this.writeKey8(tmp, (byte[])pixels, vf.getWidth(), vf.getHeight(), offset, scanlineStride);
                        out.flags = 16;
                    } else {
                        this.writeDelta8(tmp, (byte[])pixels, (byte[])this.previousPixels, vf.getWidth(), vf.getHeight(), offset, scanlineStride);
                        out.flags = 0;
                    }
                    if (this.previousPixels == null) {
                        this.previousPixels = pixels.clone();
                        break;
                    }
                    System.arraycopy(pixels, 0, this.previousPixels, 0, pixels.length);
                    break;
                }
                case 16: {
                    Object[] pixels = this.getRGB15(in);
                    if (pixels == null) {
                        out.flags = 2;
                        return;
                    }
                    if ((in.flags & 0x10) != 0 || this.previousPixels == null) {
                        this.writeKey16(tmp, (short[])pixels, vf.getWidth(), vf.getHeight(), offset, scanlineStride);
                        out.flags = 16;
                    } else {
                        this.writeDelta16(tmp, (short[])pixels, (short[])this.previousPixels, vf.getWidth(), vf.getHeight(), offset, scanlineStride);
                        out.flags = 0;
                    }
                    if (this.previousPixels == null) {
                        this.previousPixels = pixels.clone();
                        break;
                    }
                    System.arraycopy(pixels, 0, this.previousPixels, 0, pixels.length);
                    break;
                }
                case 24: {
                    Object[] pixels = this.getRGB24(in);
                    if (pixels == null) {
                        out.flags = 2;
                        return;
                    }
                    if ((in.flags & 0x10) != 0 || this.previousPixels == null) {
                        this.writeKey24(tmp, (int[])pixels, vf.getWidth(), vf.getHeight(), offset, scanlineStride);
                        out.flags = 16;
                    } else {
                        this.writeDelta24(tmp, (int[])pixels, (int[])this.previousPixels, vf.getWidth(), vf.getHeight(), offset, scanlineStride);
                        out.flags = 0;
                    }
                    if (this.previousPixels == null) {
                        this.previousPixels = pixels.clone();
                        break;
                    }
                    System.arraycopy(pixels, 0, this.previousPixels, 0, pixels.length);
                    break;
                }
                default: {
                    out.flags = 2;
                    return;
                }
            }
            out.data = tmp.getBuffer();
            out.offset = 0;
            out.length = (int)tmp.getStreamPosition();
            return;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            out.flags = 2;
            return;
        }
    }

    public void writeKey8(OutputStream out, byte[] data, int width, int height, int offset, int scanlineStride) throws IOException {
        this.temp.clear();
        int ymax = offset + height * scanlineStride;
        int upsideDown = ymax - scanlineStride + offset;
        int y = offset;
        while (y < ymax) {
            int xy = upsideDown - y;
            int xymax = xy + width;
            int literalCount = 0;
            int repeatCount = 0;
            while (xy < xymax) {
                byte v = data[xy];
                repeatCount = 0;
                while (xy < xymax && repeatCount < 255) {
                    if (data[xy] != v) break;
                    ++xy;
                    ++repeatCount;
                }
                xy -= repeatCount;
                if (repeatCount < 3) {
                    if (++literalCount == 254) {
                        this.temp.write(0);
                        this.temp.write(literalCount);
                        this.temp.write(data, xy - literalCount + 1, literalCount);
                        literalCount = 0;
                    }
                } else {
                    if (literalCount > 0) {
                        if (literalCount < 3) {
                            while (literalCount > 0) {
                                this.temp.write(1);
                                this.temp.write(data[xy - literalCount]);
                                --literalCount;
                            }
                        } else {
                            this.temp.write(0);
                            this.temp.write(literalCount);
                            this.temp.write(data, xy - literalCount, literalCount);
                            if (literalCount % 2 == 1) {
                                this.temp.write(0);
                            }
                            literalCount = 0;
                        }
                    }
                    this.temp.write(repeatCount);
                    this.temp.write(v);
                    xy += repeatCount - 1;
                }
                ++xy;
            }
            if (literalCount > 0) {
                if (literalCount < 3) {
                    while (literalCount > 0) {
                        this.temp.write(1);
                        this.temp.write(data[xy - literalCount]);
                        --literalCount;
                    }
                } else {
                    this.temp.write(0);
                    this.temp.write(literalCount);
                    this.temp.write(data, xy - literalCount, literalCount);
                    if (literalCount % 2 == 1) {
                        this.temp.write(0);
                    }
                }
                literalCount = 0;
            }
            this.temp.write(0);
            this.temp.write(0);
            y += scanlineStride;
        }
        this.temp.write(0);
        this.temp.write(1);
        DeflaterOutputStream defl = new DeflaterOutputStream(out);
        this.temp.toOutputStream(defl);
        defl.finish();
    }

    /*
     * Unable to fully structure code
     */
    public void writeDelta8(OutputStream out, byte[] data, byte[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        this.temp.clear();
        ymax = offset + height * scanlineStride;
        upsideDown = ymax - scanlineStride + offset;
        verticalOffset = 0;
        y = offset;
        while (y < ymax) {
            block19: {
                xy = upsideDown - y;
                xymax = xy + width;
                skipCount = 0;
                while (xy < xymax) {
                    if (data[xy] != prev[xy]) break;
                    ++xy;
                    ++skipCount;
                }
                if (skipCount != width) ** GOTO lbl24
                ++verticalOffset;
                break block19;
lbl-1000:
                // 1 sources

                {
                    this.temp.write(0);
                    this.temp.write(2);
                    this.temp.write(Math.min(255, skipCount));
                    this.temp.write(Math.min(255, verticalOffset));
                    skipCount -= Math.min(255, skipCount);
                    verticalOffset -= Math.min(255, verticalOffset);
lbl24:
                    // 2 sources

                    ** while (verticalOffset > 0 || skipCount > 0)
                }
lbl25:
                // 1 sources

                literalCount = 0;
                repeatCount = 0;
                while (xy < xymax) {
                    block20: {
                        skipCount = 0;
                        while (xy < xymax) {
                            if (data[xy] != prev[xy]) break;
                            ++xy;
                            ++skipCount;
                        }
                        v = data[xy -= skipCount];
                        repeatCount = 0;
                        while (xy < xymax && repeatCount < 255) {
                            if (data[xy] != v) break;
                            ++xy;
                            ++repeatCount;
                        }
                        if (skipCount >= 4 || (xy -= repeatCount) + skipCount >= xymax || repeatCount >= 3) ** GOTO lbl56
                        ++literalCount;
                        break block20;
lbl-1000:
                        // 1 sources

                        {
                            if (literalCount < 3) {
                                this.temp.write(1);
                                this.temp.write(data[xy - literalCount]);
                                --literalCount;
                                continue;
                            }
                            literalRun = Math.min(254, literalCount);
                            this.temp.write(0);
                            this.temp.write(literalRun);
                            this.temp.write(data, xy - literalCount, literalRun);
                            if (literalRun % 2 == 1) {
                                this.temp.write(0);
                            }
                            literalCount -= literalRun;
lbl56:
                            // 3 sources

                            ** while (literalCount > 0)
                        }
lbl57:
                        // 1 sources

                        if (xy + skipCount == xymax) {
                            xy += skipCount - 1;
                        } else if (skipCount >= repeatCount) {
                            while (skipCount > 0) {
                                this.temp.write(0);
                                this.temp.write(2);
                                this.temp.write(Math.min(255, skipCount));
                                this.temp.write(0);
                                xy += Math.min(255, skipCount);
                                skipCount -= Math.min(255, skipCount);
                            }
                            --xy;
                        } else {
                            this.temp.write(repeatCount);
                            this.temp.write(v);
                            xy += repeatCount - 1;
                        }
                    }
                    ++xy;
                }
                while (literalCount > 0) {
                    if (literalCount < 3) {
                        this.temp.write(1);
                        this.temp.write(data[xy - literalCount]);
                        --literalCount;
                        continue;
                    }
                    literalRun = Math.min(254, literalCount);
                    this.temp.write(0);
                    this.temp.write(literalRun);
                    this.temp.write(data, xy - literalCount, literalRun);
                    if (literalRun % 2 == 1) {
                        this.temp.write(0);
                    }
                    literalCount -= literalRun;
                }
                this.temp.write(0);
                this.temp.write(0);
            }
            y += scanlineStride;
        }
        this.temp.write(0);
        this.temp.write(1);
        if (this.temp.length() == 2L) {
            this.temp.toOutputStream(out);
        } else {
            defl = new DeflaterOutputStream(out);
            this.temp.toOutputStream(defl);
            defl.finish();
        }
    }

    public void writeKey16(OutputStream out, short[] data, int width, int height, int offset, int scanlineStride) throws IOException {
        this.temp.clear();
        int ymax = offset + height * scanlineStride;
        int upsideDown = ymax - scanlineStride + offset;
        int y = offset;
        while (y < ymax) {
            int xy = upsideDown - y;
            int xymax = xy + width;
            int literalCount = 0;
            int repeatCount = 0;
            while (xy < xymax) {
                short v = data[xy];
                repeatCount = 0;
                while (xy < xymax && repeatCount < 255) {
                    if (data[xy] != v) break;
                    ++xy;
                    ++repeatCount;
                }
                xy -= repeatCount;
                if (repeatCount < 3) {
                    if (++literalCount == 254) {
                        this.temp.write(0);
                        this.temp.write(literalCount);
                        this.temp.writeShorts(data, xy - literalCount + 1, literalCount);
                        literalCount = 0;
                    }
                } else {
                    if (literalCount > 0) {
                        if (literalCount < 3) {
                            while (literalCount > 0) {
                                this.temp.write(1);
                                this.temp.writeShort(data[xy - literalCount]);
                                --literalCount;
                            }
                        } else {
                            this.temp.write(0);
                            this.temp.write(literalCount);
                            this.temp.writeShorts(data, xy - literalCount, literalCount);
                            literalCount = 0;
                        }
                    }
                    this.temp.write(repeatCount);
                    this.temp.writeShort(v);
                    xy += repeatCount - 1;
                }
                ++xy;
            }
            if (literalCount > 0) {
                if (literalCount < 3) {
                    while (literalCount > 0) {
                        this.temp.write(1);
                        this.temp.writeShort(data[xy - literalCount]);
                        --literalCount;
                    }
                } else {
                    this.temp.write(0);
                    this.temp.write(literalCount);
                    this.temp.writeShorts(data, xy - literalCount, literalCount);
                }
                literalCount = 0;
            }
            this.temp.write(0);
            this.temp.write(0);
            y += scanlineStride;
        }
        this.temp.write(0);
        this.temp.write(1);
        DeflaterOutputStream defl = new DeflaterOutputStream(out);
        this.temp.toOutputStream(defl);
        defl.finish();
    }

    /*
     * Unable to fully structure code
     */
    public void writeDelta16(OutputStream out, short[] data, short[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        this.temp.clear();
        ymax = offset + height * scanlineStride;
        upsideDown = ymax - scanlineStride + offset;
        verticalOffset = 0;
        y = offset;
        while (y < ymax) {
            block17: {
                xy = upsideDown - y;
                xymax = xy + width;
                skipCount = 0;
                while (xy < xymax) {
                    if (data[xy] != prev[xy]) break;
                    ++xy;
                    ++skipCount;
                }
                if (skipCount != width) ** GOTO lbl24
                ++verticalOffset;
                break block17;
lbl-1000:
                // 1 sources

                {
                    this.temp.write(0);
                    this.temp.write(2);
                    this.temp.write(Math.min(255, skipCount));
                    this.temp.write(Math.min(255, verticalOffset));
                    skipCount -= Math.min(255, skipCount);
                    verticalOffset -= Math.min(255, verticalOffset);
lbl24:
                    // 2 sources

                    ** while (verticalOffset > 0 || skipCount > 0)
                }
lbl25:
                // 1 sources

                literalCount = 0;
                repeatCount = 0;
                while (xy < xymax) {
                    block18: {
                        skipCount = 0;
                        while (xy < xymax) {
                            if (data[xy] != prev[xy]) break;
                            ++xy;
                            ++skipCount;
                        }
                        v = data[xy -= skipCount];
                        repeatCount = 0;
                        while (xy < xymax && repeatCount < 255) {
                            if (data[xy] != v) break;
                            ++xy;
                            ++repeatCount;
                        }
                        if (skipCount >= 4 || (xy -= repeatCount) + skipCount >= xymax || repeatCount >= 3) ** GOTO lbl54
                        ++literalCount;
                        break block18;
lbl-1000:
                        // 1 sources

                        {
                            if (literalCount < 3) {
                                this.temp.write(1);
                                this.temp.writeShort(data[xy - literalCount]);
                                --literalCount;
                                continue;
                            }
                            literalRun = Math.min(254, literalCount);
                            this.temp.write(0);
                            this.temp.write(literalRun);
                            this.temp.writeShorts(data, xy - literalCount, literalRun);
                            literalCount -= literalRun;
lbl54:
                            // 3 sources

                            ** while (literalCount > 0)
                        }
lbl55:
                        // 1 sources

                        if (xy + skipCount == xymax) {
                            xy += skipCount - 1;
                        } else if (skipCount >= repeatCount) {
                            while (skipCount > 0) {
                                this.temp.write(0);
                                this.temp.write(2);
                                this.temp.write(Math.min(255, skipCount));
                                this.temp.write(0);
                                xy += Math.min(255, skipCount);
                                skipCount -= Math.min(255, skipCount);
                            }
                            --xy;
                        } else {
                            this.temp.write(repeatCount);
                            this.temp.writeShort(v);
                            xy += repeatCount - 1;
                        }
                    }
                    ++xy;
                }
                while (literalCount > 0) {
                    if (literalCount < 3) {
                        this.temp.write(1);
                        this.temp.writeShort(data[xy - literalCount]);
                        --literalCount;
                        continue;
                    }
                    literalRun = Math.min(254, literalCount);
                    this.temp.write(0);
                    this.temp.write(literalRun);
                    this.temp.writeShorts(data, xy - literalCount, literalRun);
                    literalCount -= literalRun;
                }
                this.temp.write(0);
                this.temp.write(0);
            }
            y += scanlineStride;
        }
        this.temp.write(0);
        this.temp.write(1);
        if (this.temp.length() == 2L) {
            this.temp.toOutputStream(out);
        } else {
            defl = new DeflaterOutputStream(out);
            this.temp.toOutputStream(defl);
            defl.finish();
        }
    }

    public void writeKey24(OutputStream out, int[] data, int width, int height, int offset, int scanlineStride) throws IOException {
        this.temp.clear();
        int ymax = offset + height * scanlineStride;
        int upsideDown = ymax - scanlineStride + offset;
        int y = offset;
        while (y < ymax) {
            int xy = upsideDown - y;
            int xymax = xy + width;
            int literalCount = 0;
            int repeatCount = 0;
            while (xy < xymax) {
                int v = data[xy];
                repeatCount = 0;
                while (xy < xymax && repeatCount < 255) {
                    if (data[xy] != v) break;
                    ++xy;
                    ++repeatCount;
                }
                xy -= repeatCount;
                if (repeatCount < 3) {
                    if (++literalCount == 254) {
                        this.temp.write(0);
                        this.temp.write(literalCount);
                        this.writeInts24LE(this.temp, data, xy - literalCount + 1, literalCount);
                        literalCount = 0;
                    }
                } else {
                    if (literalCount > 0) {
                        if (literalCount < 3) {
                            while (literalCount > 0) {
                                this.temp.write(1);
                                this.writeInt24LE(this.temp, data[xy - literalCount]);
                                --literalCount;
                            }
                        } else {
                            this.temp.write(0);
                            this.temp.write(literalCount);
                            this.writeInts24LE(this.temp, data, xy - literalCount, literalCount);
                            literalCount = 0;
                        }
                    }
                    this.temp.write(repeatCount);
                    this.writeInt24LE(this.temp, v);
                    xy += repeatCount - 1;
                }
                ++xy;
            }
            if (literalCount > 0) {
                if (literalCount < 3) {
                    while (literalCount > 0) {
                        this.temp.write(1);
                        this.writeInt24LE(this.temp, data[xy - literalCount]);
                        --literalCount;
                    }
                } else {
                    this.temp.write(0);
                    this.temp.write(literalCount);
                    this.writeInts24LE(this.temp, data, xy - literalCount, literalCount);
                }
                literalCount = 0;
            }
            this.temp.write(0);
            this.temp.write(0);
            y += scanlineStride;
        }
        this.temp.write(0);
        this.temp.write(1);
        DeflaterOutputStream defl = new DeflaterOutputStream(out);
        this.temp.toOutputStream(defl);
        defl.finish();
    }

    /*
     * Unable to fully structure code
     */
    public void writeDelta24(OutputStream out, int[] data, int[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        this.temp.clear();
        ymax = offset + height * scanlineStride;
        upsideDown = ymax - scanlineStride + offset;
        verticalOffset = 0;
        y = offset;
        while (y < ymax) {
            block17: {
                xy = upsideDown - y;
                xymax = xy + width;
                skipCount = 0;
                while (xy < xymax) {
                    if (data[xy] != prev[xy]) break;
                    ++xy;
                    ++skipCount;
                }
                if (skipCount != width) ** GOTO lbl24
                ++verticalOffset;
                break block17;
lbl-1000:
                // 1 sources

                {
                    this.temp.write(0);
                    this.temp.write(2);
                    this.temp.write(Math.min(255, skipCount));
                    this.temp.write(Math.min(255, verticalOffset));
                    skipCount -= Math.min(255, skipCount);
                    verticalOffset -= Math.min(255, verticalOffset);
lbl24:
                    // 2 sources

                    ** while (verticalOffset > 0 || skipCount > 0)
                }
lbl25:
                // 1 sources

                literalCount = 0;
                repeatCount = 0;
                while (xy < xymax) {
                    block18: {
                        skipCount = 0;
                        while (xy < xymax) {
                            if (data[xy] != prev[xy]) break;
                            ++xy;
                            ++skipCount;
                        }
                        v = data[xy -= skipCount];
                        repeatCount = 0;
                        while (xy < xymax && repeatCount < 255) {
                            if (data[xy] != v) break;
                            ++xy;
                            ++repeatCount;
                        }
                        if (skipCount >= 4 || (xy -= repeatCount) + skipCount >= xymax || repeatCount >= 3) ** GOTO lbl54
                        ++literalCount;
                        break block18;
lbl-1000:
                        // 1 sources

                        {
                            if (literalCount < 3) {
                                this.temp.write(1);
                                this.writeInt24LE(this.temp, data[xy - literalCount]);
                                --literalCount;
                                continue;
                            }
                            literalRun = Math.min(254, literalCount);
                            this.temp.write(0);
                            this.temp.write(literalRun);
                            this.writeInts24LE(this.temp, data, xy - literalCount, literalRun);
                            literalCount -= literalRun;
lbl54:
                            // 3 sources

                            ** while (literalCount > 0)
                        }
lbl55:
                        // 1 sources

                        if (xy + skipCount == xymax) {
                            xy += skipCount - 1;
                        } else if (skipCount >= repeatCount) {
                            while (skipCount > 0) {
                                this.temp.write(0);
                                this.temp.write(2);
                                this.temp.write(Math.min(255, skipCount));
                                this.temp.write(0);
                                xy += Math.min(255, skipCount);
                                skipCount -= Math.min(255, skipCount);
                            }
                            --xy;
                        } else {
                            this.temp.write(repeatCount);
                            this.writeInt24LE(this.temp, v);
                            xy += repeatCount - 1;
                        }
                    }
                    ++xy;
                }
                while (literalCount > 0) {
                    if (literalCount < 3) {
                        this.temp.write(1);
                        this.writeInt24LE(this.temp, data[xy - literalCount]);
                        --literalCount;
                        continue;
                    }
                    literalRun = Math.min(254, literalCount);
                    this.temp.write(0);
                    this.temp.write(literalRun);
                    this.writeInts24LE(this.temp, data, xy - literalCount, literalRun);
                    literalCount -= literalRun;
                }
                this.temp.write(0);
                this.temp.write(0);
            }
            y += scanlineStride;
        }
        this.temp.write(0);
        this.temp.write(1);
        if (this.temp.length() == 2L) {
            this.temp.toOutputStream(out);
        } else {
            defl = new DeflaterOutputStream(out);
            this.temp.toOutputStream(defl);
            defl.finish();
        }
    }

    public static void main(String[] args) {
        byte[] byArray = new byte[50];
        byArray[0] = 8;
        byArray[1] = 2;
        byArray[2] = 3;
        byArray[3] = 4;
        byArray[4] = 4;
        byArray[5] = 3;
        byArray[6] = 7;
        byArray[7] = 7;
        byArray[8] = 7;
        byArray[9] = 8;
        byArray[10] = 8;
        byArray[11] = 1;
        byArray[12] = 1;
        byArray[13] = 1;
        byArray[14] = 1;
        byArray[15] = 2;
        byArray[16] = 7;
        byArray[17] = 7;
        byArray[18] = 7;
        byArray[19] = 8;
        byArray[20] = 8;
        byArray[22] = 2;
        byArray[26] = 7;
        byArray[27] = 7;
        byArray[28] = 7;
        byArray[29] = 8;
        byArray[30] = 8;
        byArray[31] = 2;
        byArray[32] = 2;
        byArray[33] = 3;
        byArray[34] = 4;
        byArray[35] = 4;
        byArray[36] = 7;
        byArray[37] = 7;
        byArray[38] = 7;
        byArray[39] = 8;
        byArray[40] = 8;
        byArray[41] = 1;
        byArray[42] = 4;
        byArray[43] = 4;
        byArray[44] = 4;
        byArray[45] = 5;
        byArray[46] = 7;
        byArray[47] = 7;
        byArray[48] = 7;
        byArray[49] = 8;
        byte[] data = byArray;
        byte[] byArray2 = new byte[50];
        byArray2[0] = 8;
        byArray2[1] = 3;
        byArray2[2] = 3;
        byArray2[3] = 3;
        byArray2[4] = 3;
        byArray2[5] = 3;
        byArray2[6] = 7;
        byArray2[7] = 7;
        byArray2[8] = 7;
        byArray2[9] = 8;
        byArray2[10] = 8;
        byArray2[11] = 1;
        byArray2[12] = 1;
        byArray2[13] = 1;
        byArray2[14] = 1;
        byArray2[15] = 1;
        byArray2[16] = 7;
        byArray2[17] = 7;
        byArray2[18] = 7;
        byArray2[19] = 8;
        byArray2[20] = 8;
        byArray2[21] = 5;
        byArray2[22] = 5;
        byArray2[23] = 5;
        byArray2[24] = 5;
        byArray2[26] = 7;
        byArray2[27] = 7;
        byArray2[28] = 7;
        byArray2[29] = 8;
        byArray2[30] = 8;
        byArray2[31] = 2;
        byArray2[32] = 2;
        byArray2[36] = 7;
        byArray2[37] = 7;
        byArray2[38] = 7;
        byArray2[39] = 8;
        byArray2[40] = 8;
        byArray2[41] = 2;
        byArray2[45] = 5;
        byArray2[46] = 7;
        byArray2[47] = 7;
        byArray2[48] = 7;
        byArray2[49] = 8;
        byte[] prev = byArray2;
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        DataChunkOutputStream out = new DataChunkOutputStream(buf);
        TechSmithCodec enc = new TechSmithCodec();
        try {
            enc.writeDelta8(out, data, prev, 1, 8, 10, 5);
            out.close();
            byte[] result = buf.toByteArray();
            System.out.println("size:" + result.length);
            System.out.println(Arrays.toString(result));
            System.out.print("0x [");
            int i = 0;
            while (i < result.length) {
                if (i != 0) {
                    System.out.print(',');
                }
                String hex = "00" + Integer.toHexString(result[i]);
                System.out.print(hex.substring(hex.length() - 2));
                ++i;
            }
            System.out.println(']');
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

