/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.components;

import com.kms.katalon.composer.components.ComponentBundleActivator;
import com.kms.katalon.composer.components.controls.HoverableInformationComposite;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.mobile.objectspy.constant.ComposerMobileObjectspyMessageConstants;
import com.kms.katalon.composer.mobile.objectspy.interfaces.ITestCloudDeviceSelectorComposite;
import com.kms.katalon.testcloud.core.event.TestCloudDevicePlatformSelectedEvent;
import com.kms.katalon.testcloud.core.model.TestCloudCapability;
import com.kms.katalon.testcloud.core.model.TestCloudMobileAvailability;
import com.kms.katalon.testcloud.core.model.TestCloudMobileDevice;
import com.kms.katalon.testcloud.core.model.TestCloudMobilePlatformName;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.semver4j.Semver;

@Creatable
public class TestCloudDeviceSelectorComposite
implements ITestCloudDeviceSelectorComposite {
    @Inject
    IEventBroker eventBroker;
    private Combo testCloudDevicePlatform;
    private Combo testCloudDevicePlatformVersion;
    private Combo testCloudDeviceName;
    private Button btnHighAvailableDevice;
    private Link noDevicesTroubleshootingLink;
    private String latestSelectionOsVersion;
    private String latestSelectionDeviceName;
    private String[] platforms = new String[]{TestCloudMobilePlatformName.ANDROID.toString(), TestCloudMobilePlatformName.IOS.toString()};
    private String[] DEFAULT_DEVICE_PLATFORM_TEXT_ARRAY = new String[]{"OS"};
    private String[] DEFAULT_DEVICE_PLATFORM_VERSION_TEXT_ARRAY = new String[]{"OS Version"};
    private String[] DEFAULT_DEVICE_NAME_TEXT_ARRAY = new String[]{"Device"};
    private String TROUBLESHOOTING_MESSAGE = ComposerMobileObjectspyMessageConstants.MSG_NO_DEVICES + " <a href=\"" + ComposerMobileObjectspyMessageConstants.NO_TESTCLOUD_DEVICES_TROUBLESHOOTING_LINK + "\">" + ComposerMobileObjectspyMessageConstants.MSG_WRAPPED_NO_DEVICES_TROUBLESHOOTING_GUIDE + "</a>";
    private List<TestCloudMobileDevice> devicesList = new ArrayList<TestCloudMobileDevice>();
    Predicate<TestCloudMobileDevice> highAvailabilityFilter = device -> !this.btnHighAvailableDevice.getSelection() || TestCloudMobileAvailability.HIGH.equals((Object)device.getCapability().getAvailability());

    @Override
    public void setTestCloudDevices(List<TestCloudMobileDevice> devices) {
        if (Objects.nonNull(devices)) {
            this.setTroubleshootingMessage(devices.isEmpty());
            this.devicesList.clear();
            this.devicesList.addAll(devices);
            if (!devices.isEmpty()) {
                this.testCloudDevicePlatform.setItems(this.platforms);
                this.testCloudDevicePlatform.select(0);
                if (!ComponentBundleActivator.isDarkTheme((Display)this.testCloudDevicePlatform.getDisplay())) {
                    this.testCloudDevicePlatform.setForeground(ColorUtil.BLACK_COLOR);
                }
                this.bindingPlatformVersion();
                this.bindingDeviceName();
            } else {
                this.setEmptyText(this.testCloudDevicePlatform, this.DEFAULT_DEVICE_PLATFORM_TEXT_ARRAY);
                this.setEmptyText(this.testCloudDevicePlatformVersion, this.DEFAULT_DEVICE_PLATFORM_VERSION_TEXT_ARRAY);
                this.setEmptyText(this.testCloudDeviceName, this.DEFAULT_DEVICE_NAME_TEXT_ARRAY);
            }
        }
    }

    private void setTroubleshootingMessage(boolean isVisible) {
        this.noDevicesTroubleshootingLink.setVisible(isVisible);
        if (this.noDevicesTroubleshootingLink.getLayoutData() != null) {
            ((GridData)this.noDevicesTroubleshootingLink.getLayoutData()).exclude = !isVisible;
        }
        this.noDevicesTroubleshootingLink.pack();
        this.noDevicesTroubleshootingLink.getParent().layout();
    }

    private String getDeviceDisplayName(TestCloudMobileDevice device) {
        if (device.getCapability() == null) {
            return device.getDisplayName();
        }
        return !TestCloudMobileAvailability.LOW.equals((Object)device.getCapability().getAvailability()) ? device.getDisplayName() : device.getDisplayName() + " *";
    }

    @Override
    public Composite render(Composite parent, int type) {
        this.createLabelComposite(parent);
        this.createDeviceSelectionComposite(parent);
        this.addListeners();
        return parent;
    }

    private void createLabelComposite(Composite parent) {
        Composite deviceLabelComposite = new Composite(parent, 0);
        GridLayout deviceNameCompositeLayout = new GridLayout(2, false);
        deviceNameCompositeLayout.marginHeight = 0;
        deviceNameCompositeLayout.marginWidth = 0;
        deviceLabelComposite.setLayout((Layout)deviceNameCompositeLayout);
        deviceLabelComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblDeviceName = new Label(deviceLabelComposite, 0);
        lblDeviceName.setText(ComposerMobileObjectspyMessageConstants.DIA_LBL_DEVICE_NAME);
        GridData gdDeviceNameLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        lblDeviceName.setLayoutData((Object)gdDeviceNameLabel);
        new HoverableInformationComposite(deviceLabelComposite, ComposerMobileObjectspyMessageConstants.MSG_LOW_AVAILABILITY_DEVICES);
    }

    private void createDeviceSelectionComposite(Composite parent) {
        Composite deviceNameCompposite = new Composite(parent, 0);
        GridLayout deviceNameCompositeLayout = new GridLayout(3, true);
        deviceNameCompositeLayout.marginHeight = 0;
        deviceNameCompositeLayout.marginWidth = 0;
        deviceNameCompposite.setLayout((Layout)deviceNameCompositeLayout);
        deviceNameCompposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.testCloudDevicePlatform = new Combo(deviceNameCompposite, 8);
        this.testCloudDevicePlatform.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.setEmptyText(this.testCloudDevicePlatform, this.DEFAULT_DEVICE_PLATFORM_TEXT_ARRAY);
        this.testCloudDevicePlatform.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TestCloudDeviceSelectorComposite.this.bindingPlatformVersion();
                TestCloudDeviceSelectorComposite.this.bindingDeviceName();
                TestCloudDeviceSelectorComposite.this.eventBroker.send("ON_TESTCLOUD_DEVICE_PLATFORM_SELECTED", (Object)new TestCloudDevicePlatformSelectedEvent(TestCloudMobilePlatformName.fromString((String)TestCloudDeviceSelectorComposite.this.testCloudDevicePlatform.getText())));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.testCloudDevicePlatformVersion = new Combo(deviceNameCompposite, 8);
        this.testCloudDevicePlatformVersion.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.setEmptyText(this.testCloudDevicePlatformVersion, this.DEFAULT_DEVICE_PLATFORM_VERSION_TEXT_ARRAY);
        this.testCloudDeviceName = new Combo(deviceNameCompposite, 8);
        this.testCloudDeviceName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.setEmptyText(this.testCloudDeviceName, this.DEFAULT_DEVICE_NAME_TEXT_ARRAY);
        this.noDevicesTroubleshootingLink = new Link(parent, 0);
        this.noDevicesTroubleshootingLink.setText(this.TROUBLESHOOTING_MESSAGE);
        this.noDevicesTroubleshootingLink.setVisible(false);
        this.btnHighAvailableDevice = new Button(parent, 32);
        this.btnHighAvailableDevice.setText(ComposerMobileObjectspyMessageConstants.DIA_BTN_HIGH_AVAILABILITY_DEVICES);
        this.btnHighAvailableDevice.setSelection(true);
    }

    private void setEmptyText(Combo aCombo, String ... value) {
        aCombo.setForeground(ColorUtil.TESTCLOUD_EMPTY_TEXT_ON_COMBO_COLOR);
        aCombo.setItems(value);
        aCombo.select(0);
    }

    private void addListeners() {
        this.testCloudDevicePlatform.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCloudDeviceSelectorComposite.this.clearLatestSelection();
                TestCloudDeviceSelectorComposite.this.bindingPlatformVersion();
                TestCloudDeviceSelectorComposite.this.bindingDeviceName();
            }
        });
        this.testCloudDevicePlatformVersion.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCloudDeviceSelectorComposite.this.bindingDeviceName();
                TestCloudDeviceSelectorComposite.this.latestSelectionOsVersion = TestCloudDeviceSelectorComposite.this.testCloudDevicePlatformVersion.getText();
            }
        });
        this.testCloudDeviceName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCloudDeviceSelectorComposite.this.latestSelectionDeviceName = TestCloudDeviceSelectorComposite.this.testCloudDeviceName.getText();
            }
        });
        this.noDevicesTroubleshootingLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCloudDeviceSelectorComposite.this.onNoDevicesTroubleshootingLinkClicked(e);
            }
        });
        this.btnHighAvailableDevice.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCloudDeviceSelectorComposite.this.bindingPlatformVersion();
                TestCloudDeviceSelectorComposite.this.bindingDeviceName();
            }
        });
    }

    private void onNoDevicesTroubleshootingLinkClicked(SelectionEvent event) {
        Program.launch((String)event.text);
    }

    private void bindingPlatformVersion() {
        String platform = this.testCloudDevicePlatform.getText();
        if (platform.equals(this.DEFAULT_DEVICE_PLATFORM_TEXT_ARRAY[0])) {
            this.setEmptyText(this.testCloudDevicePlatform, this.DEFAULT_DEVICE_PLATFORM_TEXT_ARRAY);
            this.setEmptyText(this.testCloudDevicePlatformVersion, this.DEFAULT_DEVICE_PLATFORM_VERSION_TEXT_ARRAY);
            this.setEmptyText(this.testCloudDeviceName, this.DEFAULT_DEVICE_NAME_TEXT_ARRAY);
        } else {
            int foundIndex;
            if (this.devicesList == null || this.devicesList.isEmpty()) {
                return;
            }
            String[] versionArray = (String[])this.devicesList.stream().filter(device -> device.getPlatformName().equals((Object)TestCloudMobilePlatformName.valueOf((String)platform.toUpperCase()))).filter(this.highAvailabilityFilter).map(TestCloudMobileDevice::getCapability).map(TestCloudCapability::getVersion).distinct().sorted((v1, v2) -> Semver.coerce((String)v2).compareTo(Semver.coerce((String)v1))).toArray(String[]::new);
            this.testCloudDevicePlatformVersion.clearSelection();
            this.testCloudDevicePlatformVersion.removeAll();
            this.testCloudDevicePlatformVersion.setItems(versionArray);
            int indexSelectedOsVersion = 0;
            if (this.latestSelectionOsVersion != null && (foundIndex = Arrays.asList(versionArray).indexOf(this.latestSelectionOsVersion)) != -1) {
                indexSelectedOsVersion = foundIndex;
            }
            this.testCloudDevicePlatformVersion.select(indexSelectedOsVersion);
            if (!ComponentBundleActivator.isDarkTheme((Display)this.testCloudDevicePlatformVersion.getDisplay())) {
                this.testCloudDevicePlatformVersion.setForeground(ColorUtil.BLACK_COLOR);
            }
        }
        this.latestSelectionOsVersion = this.testCloudDevicePlatformVersion.getText();
    }

    private void bindingDeviceName() {
        String platform = this.testCloudDevicePlatform.getText();
        if (platform.equals(this.DEFAULT_DEVICE_PLATFORM_TEXT_ARRAY[0])) {
            this.setEmptyText(this.testCloudDevicePlatform, this.DEFAULT_DEVICE_PLATFORM_TEXT_ARRAY);
            this.setEmptyText(this.testCloudDevicePlatformVersion, this.DEFAULT_DEVICE_PLATFORM_VERSION_TEXT_ARRAY);
            this.setEmptyText(this.testCloudDeviceName, this.DEFAULT_DEVICE_NAME_TEXT_ARRAY);
        } else {
            int foundIndex;
            String platformVersion = this.testCloudDevicePlatformVersion.getText();
            if (this.devicesList == null || this.devicesList.isEmpty()) {
                return;
            }
            String[] nameArray = (String[])this.devicesList.stream().filter(device -> device.getPlatformName().equals((Object)TestCloudMobilePlatformName.valueOf((String)platform.toUpperCase()))).filter(device -> StringUtils.equalsIgnoreCase((CharSequence)device.getCapability().getVersion(), (CharSequence)platformVersion)).filter(this.highAvailabilityFilter).distinct().sorted(this.sortPrivateDevicesFirst()).map(device -> this.getDeviceDisplayName((TestCloudMobileDevice)device)).toArray(String[]::new);
            this.testCloudDeviceName.clearSelection();
            this.testCloudDeviceName.removeAll();
            this.testCloudDeviceName.setItems(nameArray);
            int indexDevice = 0;
            if (this.latestSelectionDeviceName != null && (foundIndex = Arrays.asList(nameArray).indexOf(this.latestSelectionDeviceName)) != -1) {
                indexDevice = foundIndex;
            }
            this.testCloudDeviceName.select(indexDevice);
            if (!ComponentBundleActivator.isDarkTheme((Display)this.testCloudDeviceName.getDisplay())) {
                this.testCloudDeviceName.setForeground(ColorUtil.BLACK_COLOR);
            }
        }
        this.latestSelectionDeviceName = this.testCloudDeviceName.getText();
    }

    public Comparator<? super TestCloudMobileDevice> sortPrivateDevicesFirst() {
        return (device1, device2) -> {
            boolean hasUdid2;
            TestCloudCapability capability1 = device1.getCapability();
            TestCloudCapability capability2 = device2.getCapability();
            boolean hasUdid1 = capability1 != null && StringUtils.isNotBlank((CharSequence)capability1.getUdid());
            boolean bl = hasUdid2 = capability2 != null && StringUtils.isNotBlank((CharSequence)capability2.getUdid());
            if (hasUdid1 == hasUdid2) {
                return device1.getDisplayName().compareTo(device2.getDisplayName());
            }
            return hasUdid1 ? -1 : 1;
        };
    }

    @Override
    public TestCloudMobileDevice getSelectionDevice() {
        this.clearLatestSelection();
        TestCloudMobileDevice testCloudDevice = null;
        if (this.testCloudDevicePlatform == null || this.testCloudDevicePlatformVersion == null || this.testCloudDeviceName == null) {
            return testCloudDevice;
        }
        if (this.testCloudDevicePlatform.isDisposed() || this.testCloudDevicePlatformVersion.isDisposed() || this.testCloudDeviceName.isDisposed()) {
            return testCloudDevice;
        }
        if (this.testCloudDevicePlatform.getItem(0).equals(this.DEFAULT_DEVICE_PLATFORM_TEXT_ARRAY[0]) || this.testCloudDevicePlatformVersion.getItem(0).equals(this.DEFAULT_DEVICE_PLATFORM_VERSION_TEXT_ARRAY[0]) || this.testCloudDeviceName.getItem(0).equals(this.DEFAULT_DEVICE_NAME_TEXT_ARRAY[0])) {
            return testCloudDevice;
        }
        String platform = this.testCloudDevicePlatform.getText();
        String platformVersion = this.testCloudDevicePlatformVersion.getText();
        String deviceName = this.getTestCloudDeviceNameText();
        Optional<TestCloudMobileDevice> firstDevice = this.devicesList.stream().filter(device -> device.getPlatformName().equals((Object)TestCloudMobilePlatformName.valueOf((String)platform.toUpperCase()))).filter(device -> StringUtils.equalsIgnoreCase((CharSequence)device.getCapability().getVersion(), (CharSequence)platformVersion)).filter(device -> StringUtils.equals((CharSequence)device.getDisplayName(), (CharSequence)deviceName)).filter(this.highAvailabilityFilter).findFirst();
        if (firstDevice.isPresent()) {
            testCloudDevice = firstDevice.get();
        }
        this.latestSelectionDeviceName = this.testCloudDeviceName.getText();
        this.latestSelectionOsVersion = this.testCloudDevicePlatformVersion.getText();
        return testCloudDevice;
    }

    private String getTestCloudDeviceNameText() {
        String rawText = this.testCloudDeviceName.getText();
        int asteriskIndex = rawText.indexOf(42);
        if (asteriskIndex != -1) {
            return rawText.substring(0, asteriskIndex).trim();
        }
        return rawText;
    }

    @Override
    public String getDefaultDevicePlatformValue() {
        return this.DEFAULT_DEVICE_PLATFORM_TEXT_ARRAY[0];
    }

    private void clearLatestSelection() {
        this.latestSelectionOsVersion = null;
        this.latestSelectionDeviceName = null;
    }
}

